% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_netmhc2pan_bin_url.R
\name{check_netmhc2pan_bin_url}
\alias{check_netmhc2pan_bin_url}
\title{Check the URL of the NetMHCIIpan binary tarball}
\usage{
check_netmhc2pan_bin_url(
  netmhc2pan_bin_url = get_netmhc2pan_bin_url(),
  verbose = FALSE,
  netmhc2pan_archive_filename = get_netmhc2pan_archive_filename(),
  temp_local_file = tempfile(pattern = "check_netmhc2pan_bin_url_")
)
}
\arguments{
\item{netmhc2pan_bin_url}{URL to download the
NetMHCIIpan binary tarball file from,
similar to, for example,
\code{https://www.cbs.dtu.dk/download/12345678-1234-1234-1234-123456789ABC}.
Use \link{get_netmhc2pan_bin_url} to get the default URL.}

\item{verbose}{set to TRUE for more output}

\item{netmhc2pan_archive_filename}{the NetMHC2pan archive
filename, for example \code{netMHCIIpan-3.2.Linux.tar.gz},
which is used in installation of NetMHC2pan.
Use \link{get_netmhc2pan_archive_filename} to get this filename.}

\item{temp_local_file}{path to the temporary file to store the URL to.
This file will be deleted afterwards.}
}
\description{
Check the URL of the NetMHCIIpan binary tarball is valid,
will stop if not.
This URL link expires after 4 hours.
}
