% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diffnet-methods.r
\name{as.array.diffnet}
\alias{as.array.diffnet}
\title{Coerce a diffnet graph into an array}
\usage{
\method{as.array}{diffnet}(x, ...)
}
\arguments{
\item{x}{A diffnet object.}

\item{...}{Ignored.}
}
\value{
A three-dimensional array of \eqn{T} matrices of size \eqn{n\times n}{n * n}.
}
\description{
Coerce a diffnet graph into an array
}
\details{
The function takes the list of sparse matrices stored in \code{x} and creates
an array with them. Attributes and other elements from the diffnet object are
dropped.

\code{dimnames} are obtained from the metadata of the diffnet object.
}
\examples{
# Creating a random diffnet object
set.seed(84117)
mydiffnet <- rdiffnet(30, 5)

# Coercing it into an array
as.array(mydiffnet)
}
\seealso{
\code{\link{diffnet}}.

Other diffnet methods: \code{\link{\%*\%}},
  \code{\link{as_diffnet}}, \code{\link{c.diffnet}},
  \code{\link{diffnet-arithmetic}},
  \code{\link{diffnet_index}},
  \code{\link{summary.diffnet}}
}
