% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare.R
\name{compare}
\alias{compare}
\title{Compare Networks Many-to-Many}
\usage{
compare(
  networks,
  net_kind = "matrix",
  method = "DD",
  cause_orientation = "row",
  DD_kind = "all",
  DD_weight = 1,
  max_norm = FALSE,
  size_different = FALSE,
  cores = 1,
  diffusion_sampling = 2,
  diffusion_limit = 10,
  verbose = FALSE
)
}
\arguments{
\item{networks}{The networks being compared to the target network}

\item{net_kind}{If the network is an adjacency matrix ("matrix") or an edge list ("list"). Defaults to "matrix".}

\item{method}{This determines the method used to compare networks at the heart of the classification. Currently "DD" (Degree Distribution) and "align" (the align function which compares networks by the entropy of diffusion on them) are supported. Future versions will allow user-defined methods. Defaults to "DD".}

\item{cause_orientation}{= The orientation of directed adjacency matrices. Defaults to "row".}

\item{DD_kind}{= A vector of network properties to be used to compare networks. Defaults to "all", which is the average of the in- and out-degrees.}

\item{DD_weight}{= Weights of each network property in DD_kind. Defaults to 1, which is equal weighting for each property.}

\item{max_norm}{Binary variable indicating if each network property should be normalized so its max value (if a node-level property) is one. Defaults to FALSE.}

\item{size_different}{Defaults to FALSE. If TRUE, will ensure the node-level properties being compared are vectors of the same length, which is accomplished using splines.}

\item{cores}{Defaults to 1. The number of cores to run the classification on. When set to 1 parallelization will be ignored.}

\item{diffusion_sampling}{Base of the power to use to nonlinearly sample the diffusion kernels if method = "align". Defaults to 2.}

\item{diffusion_limit}{Number of markov steps in the diffusion kernels if method = "align". Defaults to 10.}

\item{verbose}{Defaults to TRUE. Whether to print all messages.}
}
\value{
A square matrix with dimensions equal to the number of networks being compared, where the ij element is the comparison of networks i and j.
}
\description{
Compares one network to a list of many networks.
}
\details{
Note: Currently each process is assumed to have a single governing parameter.
}
\examples{
# Import netcom
library(netcom)

# Adjacency matrix
size <- 10
comparisons <- 50
networks <- list()
for (net in 1:comparisons) {
     networks[[net]] = matrix(
         sample(
             c(0,1), 
             size = size^2, 
             replace = TRUE), 
         nrow = size,
         ncol = size)
}
compare(networks = networks)

}
\references{
Langendorf, R. E., & Burgess, M. G. (2020). Empirically Classifying Network Mechanisms. arXiv preprint arXiv:2012.15863.
}
