% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neon_store.R
\name{neon_store}
\alias{neon_store}
\title{import neon data into a local database}
\usage{
neon_store(
  table = NA,
  product = NA,
  type = NA,
  dir = neon_dir(),
  n = 500L,
  quiet = FALSE,
  ...
)
}
\arguments{
\item{table}{Include only files matching this table name (or regex pattern).
(optional).}

\item{product}{Include only files matching this NEON productCode(s)}

\item{type}{Should we prefer the basic or expanded version of this product?
See details.}

\item{dir}{Location where files should be downloaded. By default will
use the appropriate applications directory for your system
(see \link[rappdirs:user_data_dir]{rappdirs::user_data_dir}).  This default also be configured by
setting the environmental variable \code{NEONSTORE_HOME}, see \link{Sys.setenv} or
\link{Renviron}.}

\item{n}{number of files that should be read per iteration}

\item{quiet}{show progress?}

\item{...}{
  Arguments passed on to \code{\link[=neon_read]{neon_read}}
  \describe{
    \item{\code{sensor_metadata}}{logical, default TRUE. Should we add
metadata fields from file names of sensor data into the table?  Adds
DomainID, SiteID, horizontalPosition, verticalPosition, and publicationDate.
Results in slower parsing.}
    \item{\code{altrep}}{enable or disable altrep.  Logical, default \code{FALSE}. Setting to
\code{TRUE} can speed up reading, but may cause \link[vroom:vroom]{vroom::vroom} to throw
\verb{mapping error: Too many open files}.}
    \item{\code{files}}{optionally, specify a vector of file paths directly (e.g. as
provided from \link{neon_index}) and specify \code{table} argument as NULL.}
    \item{\code{site}}{4-letter site code(s) to filter on. Leave as \code{NA} to search all.}
    \item{\code{start_date}}{Download only files as recent as (\code{YYYY-MM-DD}). Leave
as \code{NA} to download up to the most recent available data.}
    \item{\code{end_date}}{Download only files up to end_date (\code{YYYY-MM-DD}). Leave as
\code{NA} to download all prior data.}
    \item{\code{ext}}{only match files with this file extension(s)}
    \item{\code{timestamp}}{only match timestamps prior this. See details in \code{\link[=neon_index]{neon_index()}}.
Should be a datetime POSIXct object (or coerce-able string)}
  }}
}
\value{
the connection object (invisibly)
}
\description{
import neon data into a local database
}
