#' Corrected sensor locations for NEON soil water content data
#'
#' A dataset containing corrected NEON sensor location depths for soil water content data
#'
#' \itemize{
#'   \item domainID (ecological domain of site)
#'   \item siteID NEON code to refer to site
#'   \item HOR.VER 3 digit code to refer to the horizontal and vertical position of measuring location.
#'   \item sensorDepth depth below surface (m)
#'   \item startDateTime time measurement was started
#'   \item endDateTime time measurement ended
#' }
#'
#' @docType data
#' @keywords datasets
#' @name swc_corrections
#' @format A data frame with 2161 rows and 6 variables
#' @source <hhttps://data.neonscience.org/data-products/DP1.00094.001>

"swc_corrections"
