% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/needs.R
\name{needs}
\alias{needs}
\title{Attach/install packages.}
\usage{
needs(...)
}
\arguments{
\item{...}{Packages, given as unquoted names or character strings. Specify a required package version as \code{package = "version"}.}
}
\description{
\code{needs} loads and attaches packages, automatically installing (and attaching) any it can't find in your libraries. It accepts any number of arguments, given as names or character strings. Optionally, supply a minimum version on a per-package basis to update old packages as needed.
}
\details{
Recommended use is to allow the function to autoload when prompted the
first time the package is loaded interactively. To change this setting later,
run \code{needs:::autoload(TRUE)} or \code{needs:::autoload(FALSE)} to turn
autoloading on or off, respectively.
}
\examples{
\dontrun{
needs()   # returns NULL

needs(foo, bar)

# require a minimum version
needs(foo,
      bar = "0.9.1",
      baz = "0.4.3")

}

}
\seealso{
\code{\link{needs-package}}
}

