% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neatmap.R
\name{neatmap}
\alias{neatmap}
\title{Explore Multi-Network Data}
\usage{
neatmap(df, scale_df, link_method = "average",
  dist_method = "euclidean", max_k = 10, reps = 1000, p_var = 1,
  p_net = 0.8, cc_seed = 100, main_title = "", xlab, ylab,
  xlab_cex = 1, ylab_cex = 1, heatmap_margins = c(50, 50, 50, 100))
}
\arguments{
\item{df}{a dataframe of network attributes containing only numeric values.}

\item{scale_df}{A string indicating whether the columns of the data frame
should be scaled, and, if so, which method should be used. The options are
"none", "ecdf", "normalize" and "percentize". If "none" is selected, then
the columns are not scaled.  If "ecdf" is selected, then the columns are
transformed into their empirical cumulative distribution. If "normalize" is
selected, each column is centered to have a mean of 0 and scaled to have a
standard deviation of 1. If "percentize" is selected, column values are 
transformed into percentiles.}

\item{link_method}{The agglomeration method to be used for hierarchical 
clustering. Defaults to the average linkage method. See other methods in
\code{\link[stats]{hclust}}.}

\item{dist_method}{The distance measure to be used between columns and 
between rows of the dataframe. Distance is used as a measure of similarity.
Defaults to euclidean distance. See other options in 
\code{\link[stats]{dist}}.}

\item{max_k}{The maximum number of clusters to consider in the consensus
clustering step. Consensus clustering will be performed for max_k-1 
iterations, i.e. for 2, 3, ..., max_k clusters. Defaults to 10.}

\item{reps}{The number of subsamples taken at each iteration of the consensus
cluster algorithm. Defaults to 1000.}

\item{p_var}{The proportion of network variables to be subsampled during 
consensus clustering. Defaults to 1.}

\item{p_net}{The proportion of networks to be subsampled during consensus
clustering. Defaults to 0.8.}

\item{cc_seed}{The seed used to ensure the reproducibility of the consensus 
clustering. Defaults to 1.}

\item{main_title}{The title of the heatmap.}

\item{xlab}{The x axis label of the heatmap.}

\item{ylab}{The y axis label of the heatmap.}

\item{xlab_cex}{The font size of the elements on the x axis.}

\item{ylab_cex}{The font size of the elements on the y axis.}

\item{heatmap_margins}{The size of the margins for the heatmap. 
See \code{\link[heatmaply]{heatmaply}}.}
}
\value{
A list containing the heatmap of the multi-network data and a list of
  length max_k-1 where each element is a list containing the consensus 
  matrix, the consensus hierarchical clustering results and the consensus
  class assignments. The list of results produced by the consensus clustering
  can be parsed using following functions in the \code{\link{neatmaps}}
  package: \code{\link{consClustResTable}}, \code{\link{consensusECDF}} and
  \code{\link{consensusChangeECDF}}.
}
\description{
\code{neatmap} produces a heatmap of multi-network data and identifies stable
clusters in its variables.
}
\details{
This function allows users to efficiently explore their multi-network data
by visualizing their data with a heatmap and assessing the stability of the
associations presented within it. \code{neatmap} requires that the data 
frame be processed into an appropriate format prior to use. Data is then 
scaled (if necessary) using of the built in methods. See (list functions) for
further details on how to prepare multi-network data for use with 
\code{neatmap}. The heatmap is created using
\code{\link[heatmaply]{heatmaply}} and the consensus clustering is performed
using \code{\link[ConsensusClusterPlus]{ConsensusClusterPlus}}
}
\examples{
# create the data frame using the network, node and edge attributes
df <- netsDataFrame(network_attr_df,
                    node_attr_df,
                    edge_df)

# run the neatmap code on df
neat_res <- neatmap(df, scale_df = "ecdf", max_k = 3, reps = 100, 
                    xlab = "vars", ylab = "nets", xlab_cex = 1, ylab_cex = 1)

# extract the heatmap
heatmap <- neat_res[[1]]

# extract the consensus clustering results
consensus_res <- neat_res[[2]]

}
\references{
For more information on the consensus clustering, see
\href{https://link.springer.com/article/10.1023\%2FA\%3A1023949509487}{Monti et al.}.
}
\author{
Philippe Boileau, \email{philippe_boileau@berkeley.edu}
}
