% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peek_neat.R
\name{peek_neat}
\alias{peek_neat}
\title{Cursory Summaries and Plots per Group}
\usage{
peek_neat(
  dat,
  values,
  group_by = NULL,
  filt = NULL,
  sep = ", ",
  collapse = NULL,
  f_print = NULL,
  f_plot = NULL,
  iqr_times = 3,
  round_to = 4,
  group_n = TRUE,
  ...
)
}
\arguments{
\item{dat}{Data frame (or name of data frame as string).}

\item{values}{String, or vector of strings: the name(s) of the column(s) in
the \code{dat} data frame, containing the vector(s) of values.}

\item{group_by}{String, or vector of strings: the name(s) of the column(s) in
the \code{dat} data frame, containing the vector(s) of factors by which the
statistics are grouped.}

\item{filt}{An expression to filter, by column values, the entire \code{dat}
data frame before performing the aggregation. The expression should use
column names alone; see Examples.}

\item{sep}{String (comma by default) for separating group names.}

\item{collapse}{Decides how to handle multiple columns of \code{values}. If
\code{NULL} (default), displays each column of values as separate groups.
Alternatively, any function can be given using which the columns are
collapsed into a single column. For example, if \code{mean} is given for
this parameter, a single column will be calculated based on the means of
all given values columns. (\code{NA} is always ignored.)}

\item{f_print}{Printing function; see details.}

\item{f_plot}{Plotting function; see details. (Provide string to skip
plotting.)}

\item{iqr_times}{The multiplication of IQR to calculate Tukey's fences, when
using default \code{f_print} (\code{NULL}); see Details. The default is
\code{3} to spot Tukey's "far outliers" (e.g. by comparing the fences with
min and max values). (Note that the usual fences, e.g. for box plots, use
\code{1.5}).}

\item{round_to}{Number of \code{\link[neatStats:ro]{significant fractional
digits to round to}}, when using default \code{f_print} (\code{NULL}).}

\item{group_n}{Logical. If \code{TRUE}, adds sample sizes (\code{n}) per
group to plots when using default \code{f_plot} (\code{NULL}).}

\item{...}{Any arguments to be passed to the \code{f_plot} function.}
}
\value{
Data frame with the printed values (if possible).
}
\description{
Cursory summaries and plots per group.
}
\details{
Prints, by default, the following data (per group): \code{mean}; 95% CI of the
mean as \code{ci_low} and \code{ci_upp}; \code{sd}; \code{median};
\code{quantile_1st} and \code{quantile_3rd} (first and third quantiles);
"Tukey's fences" as \code{fence_low} and \code{fence_upp}; minimum and maximum
values (\code{min}, \code{max}); number of \code{NA}s (\code{na}). Tukey's
fences are the upper and lower limits with distances of \code{X} times the
\code{\link[stats]{IQR}} from the actual IQR, where \code{X} is specified via
the \code{iqr_times} parameter. Returns (invisibly) the same values,
unrounded, via a data frame. If alternative \code{f_print} is given, prints
whatever value is returned from the given function (and attempts, if possible,
to create a data frame).

Creates and displays box plot(s) (per group) by default, along with overlayed
violin plot (densities proportionate to sample sizes). If alternative
\code{f_plot} is given, the first argument will be the values per group, and
all plots will be \code{\link[ggpubr:ggarrange]{arranged}} into a single plot
and displayed together. To skip plotting, just give any character as argument
(e.g. \code{"none"} or just \code{""}).
}
\examples{

data("mtcars") # load base R example dataset

# overall info for wt (Weight)
peek_neat(mtcars, 'wt')
#'
# now groupped by cyl (Number of cylinders)
peek_neat(mtcars, 'wt', group_by = 'cyl')

# grouped by cyl and gear
peek_neat(mtcars, 'wt', group_by = c('cyl', 'gear'))

# filter to only have cyl larger than  4
peek_neat(mtcars, 'wt', group_by = 'cyl', filt = cyl > 4)

# without plots
peek_neat(mtcars, 'wt', group_by = 'cyl', f_plot = "")

# with histogramms etc, using plot_neat
peek_neat(mtcars, 'wt', group_by = 'cyl', f_plot = plot_neat)

# with Q-Q plots, via ggpubr
peek_neat(mtcars, 'wt', group_by = 'cyl',
          f_plot = ggpubr::ggqqplot)


# skewness and kurtosis data via psych
\dontrun{
info_df = peek_neat(
    mtcars,
    'wt',
    group_by = 'cyl',
    f_print = psych::describe,
    f_plot = ""
)
info_df # contains all data returns by psych::describe
}

}
