% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fill_ranges.R
\name{fill_ranges}
\alias{fill_ranges}
\title{Fill the gaps between ranges.}
\usage{
fill_ranges(
  df,
  groups = NULL,
  start_var = NULL,
  end_var = NULL,
  fill = NULL,
  dimension = "date",
  fmt = "\%Y-\%m-\%d",
  tz = "UTC",
  origin = "1970-01-01"
)
}
\arguments{
\item{df}{Your data frame}

\item{groups}{Grouping variables}

\item{start_var}{Start of the range}

\item{end_var}{End of the range}

\item{fill}{Fill the missing values for values coresponding to missing ranges, e.g. 'colname1 = 0, colname2 = Missing'}

\item{dimension}{Indicate whether your range includes only dates ('date') or also timestamp ('timestamp'). Defaults to 'date'}

\item{fmt}{The format of your date or timestamp field, defaults to YMD}

\item{tz}{Time zone, defaults to UTC}

\item{origin}{Origin for timestamp conversion, defaults to 1970-01-01}
}
\value{
Returns ordered data frame (if initial input data.table, then data.table) with added missing ranges.
}
\description{
Fill the gaps between ranges.
}
\examples{
df <- data.frame(
group = c("a", "a", "b", "b", "b"),
start = c("2007-01-01", "2010-06-02", "2009-04-05", "2012-08-01", "2019-03-19"),
end = c("2008-02-05", "2013-04-05", "2009-06-03", "2013-02-17", "2021-04-21"),
cost = c(143, 144, 105, 153, 124)
)

fill_ranges(df, start_var = "start", end_var = "end", groups = "group")
}
