% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_lm.R
\name{sim_lm}
\alias{sim_lm}
\title{Simulated pdfs for the Vuong statistics using linear models}
\usage{
sim_lm(N = 1000, R = 1000, Kf = 15, Kg = 1, a = 0.125)
}
\arguments{
\item{N}{sample size}

\item{R}{the number of replications}

\item{Kf}{the number of covariates for the first model}

\item{Kg}{the number of covariates for the second model}

\item{a}{the share of the variance of \code{y} explained by the two
competing models}
}
\value{
a numeric of length \code{N} containing the values of the Vuong statistic
}
\description{
This function can be used to reproduce the examples given of Shi (2015) which illustrate the fact that the distribution of the Vuong statistic may be very different from a standard normal
}
\examples{
sim_lm(N = 100, R = 10, Kf = 10, Kg = 2, a = 0.5)
}
\references{
\insertRef{SHI:15}{ndvtest}
}
