% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CFAxisNumeric.R
\docType{class}
\name{CFAxisNumeric}
\alias{CFAxisNumeric}
\title{Numeric CF axis object}
\description{
This class represents a numeric axis. Its values are numeric.
This class is used for axes with numeric values but without further
knowledge of their nature. More specific classes descend from this class.
}
\section{Super classes}{
\code{\link[ncdfCF:CFObject]{ncdfCF::CFObject}} -> \code{\link[ncdfCF:CFAxis]{ncdfCF::CFAxis}} -> \code{CFAxisNumeric}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{friendlyClassName}}{(read-only) A nice description of the class.}

\item{\code{dimnames}}{(read-only) The coordinates of the axis as a vector.
These are by default the values of the axis, but it could also be a set
of auxiliary coordinates, if they have been set.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-CFAxisNumeric-new}{\code{CFAxisNumeric$new()}}
\item \href{#method-CFAxisNumeric-print}{\code{CFAxisNumeric$print()}}
\item \href{#method-CFAxisNumeric-brief}{\code{CFAxisNumeric$brief()}}
\item \href{#method-CFAxisNumeric-range}{\code{CFAxisNumeric$range()}}
\item \href{#method-CFAxisNumeric-indexOf}{\code{CFAxisNumeric$indexOf()}}
\item \href{#method-CFAxisNumeric-identical}{\code{CFAxisNumeric$identical()}}
\item \href{#method-CFAxisNumeric-append}{\code{CFAxisNumeric$append()}}
\item \href{#method-CFAxisNumeric-subset}{\code{CFAxisNumeric$subset()}}
\item \href{#method-CFAxisNumeric-clone}{\code{CFAxisNumeric$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="add_coordinates"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-add_coordinates'><code>ncdfCF::CFObject$add_coordinates()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="append_attribute"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-append_attribute'><code>ncdfCF::CFObject$append_attribute()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="attribute"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-attribute'><code>ncdfCF::CFObject$attribute()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="delete_attribute"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-delete_attribute'><code>ncdfCF::CFObject$delete_attribute()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="print_attributes"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-print_attributes'><code>ncdfCF::CFObject$print_attributes()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="set_attribute"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-set_attribute'><code>ncdfCF::CFObject$set_attribute()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="write_attributes"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-write_attributes'><code>ncdfCF::CFObject$write_attributes()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFAxis" data-id="can_append"><a href='../../ncdfCF/html/CFAxis.html#method-CFAxis-can_append'><code>ncdfCF::CFAxis$can_append()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFAxis" data-id="peek"><a href='../../ncdfCF/html/CFAxis.html#method-CFAxis-peek'><code>ncdfCF::CFAxis$peek()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFAxis" data-id="shard"><a href='../../ncdfCF/html/CFAxis.html#method-CFAxis-shard'><code>ncdfCF::CFAxis$shard()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFAxis" data-id="time"><a href='../../ncdfCF/html/CFAxis.html#method-CFAxis-time'><code>ncdfCF::CFAxis$time()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFAxis" data-id="write"><a href='../../ncdfCF/html/CFAxis.html#method-CFAxis-write'><code>ncdfCF::CFAxis$write()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFAxisNumeric-new"></a>}}
\if{latex}{\out{\hypertarget{method-CFAxisNumeric-new}{}}}
\subsection{Method \code{new()}}{
Create a new instance of this class.

Creating a new axis is more easily done with the \code{\link[=makeAxis]{makeAxis()}} function.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFAxisNumeric$new(nc_var, nc_dim, orientation, values)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{nc_var}}{The netCDF variable that describes this instance.}

\item{\code{nc_dim}}{The netCDF dimension that describes the dimensionality.}

\item{\code{orientation}}{The orientation (\code{X}, \code{Y}, \code{Z}, or \code{T}) or \code{""} if
different or unknown.}

\item{\code{values}}{The coordinates of this axis.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFAxisNumeric-print"></a>}}
\if{latex}{\out{\hypertarget{method-CFAxisNumeric-print}{}}}
\subsection{Method \code{print()}}{
Summary of the axis printed to the console.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFAxisNumeric$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Arguments passed on to other functions. Of particular interest
is \verb{width = } to indicate a maximum width of attribute columns.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{self}, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFAxisNumeric-brief"></a>}}
\if{latex}{\out{\hypertarget{method-CFAxisNumeric-brief}{}}}
\subsection{Method \code{brief()}}{
Some details of the axis.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFAxisNumeric$brief()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A 1-row \code{data.frame} with some details of the axis.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFAxisNumeric-range"></a>}}
\if{latex}{\out{\hypertarget{method-CFAxisNumeric-range}{}}}
\subsection{Method \code{range()}}{
Retrieve the range of coordinate values in the axis.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFAxisNumeric$range()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A numeric vector with two elements with the minimum and maximum
values in the axis, respectively.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFAxisNumeric-indexOf"></a>}}
\if{latex}{\out{\hypertarget{method-CFAxisNumeric-indexOf}{}}}
\subsection{Method \code{indexOf()}}{
Retrieve the indices of supplied coordinates on the axis. If
the axis has bounds then the supplied coordinates must fall within the
bounds to be considered valid.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFAxisNumeric$indexOf(x, method = "constant", rightmost.closed = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{A numeric vector of coordinates whose indices into the axis to
extract.}

\item{\code{method}}{Extract index values without ("constant", the default) or
with ("linear") fractional parts.}

\item{\code{rightmost.closed}}{Whether or not to include the upper limit. This
parameter is ignored for this class, effectively it always is \code{TRUE}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A vector giving the indices in \code{x} of valid coordinates provided.
Values of \code{x} outside of the range of the coordinates in the axis are
returned as \code{NA}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFAxisNumeric-identical"></a>}}
\if{latex}{\out{\hypertarget{method-CFAxisNumeric-identical}{}}}
\subsection{Method \code{identical()}}{
Tests if the axis passed to this method is identical to
\code{self}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFAxisNumeric$identical(axis)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{axis}}{The \code{CFAxisNumeric} or sub-class instance to test.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if the two axes are identical, \code{FALSE} if not.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFAxisNumeric-append"></a>}}
\if{latex}{\out{\hypertarget{method-CFAxisNumeric-append}{}}}
\subsection{Method \code{append()}}{
Append a vector of values at the end of the current values
of the axis.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFAxisNumeric$append(from)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{from}}{An instance of \code{CFAxisNumeric} or any of its descendants
whose values to append to the values of \code{self}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{CFAxisNumeric} or descendant instance with values from
self and the \code{from} axis appended.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFAxisNumeric-subset"></a>}}
\if{latex}{\out{\hypertarget{method-CFAxisNumeric-subset}{}}}
\subsection{Method \code{subset()}}{
Return an axis spanning a smaller coordinate range. This
method returns an axis which spans the range of indices given by the
\code{rng} argument.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFAxisNumeric$subset(group, rng = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{group}}{The group to create the new axis in.}

\item{\code{rng}}{The range of indices whose values from this axis to include in
the returned axis.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{CFAxisNumeric} instance covering the indicated range of
indices. If the value of the argument is \code{NULL}, return the entire
axis.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFAxisNumeric-clone"></a>}}
\if{latex}{\out{\hypertarget{method-CFAxisNumeric-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFAxisNumeric$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
