% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CFBounds.R
\docType{class}
\name{CFBounds}
\alias{CFBounds}
\title{CF bounds variable}
\description{
This class represents the bounds of an axis or an auxiliary
longitude-latitude grid.

The class manages the bounds information for an axis (2 vertices per
element) or an auxiliary longitude-latitude grid (4 vertices per element).
}
\section{Super class}{
\code{\link[ncdfCF:CFObject]{ncdfCF::CFObject}} -> \code{CFBounds}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{NCdim}}{The \link{NCDimension} that stores the netCDF dimension details
of the bounds dimension (as opposed to the dimension of the associated
axis).}

\item{\code{values}}{A matrix with the bounds values.}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{friendlyClassName}}{(read-only) A nice description of the class.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-CFBounds-new}{\code{CFBounds$new()}}
\item \href{#method-CFBounds-print}{\code{CFBounds$print()}}
\item \href{#method-CFBounds-range}{\code{CFBounds$range()}}
\item \href{#method-CFBounds-sub_bounds}{\code{CFBounds$sub_bounds()}}
\item \href{#method-CFBounds-write}{\code{CFBounds$write()}}
\item \href{#method-CFBounds-clone}{\code{CFBounds$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="append_attribute"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-append_attribute'><code>ncdfCF::CFObject$append_attribute()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="attribute"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-attribute'><code>ncdfCF::CFObject$attribute()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="delete_attribute"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-delete_attribute'><code>ncdfCF::CFObject$delete_attribute()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="print_attributes"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-print_attributes'><code>ncdfCF::CFObject$print_attributes()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="set_attribute"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-set_attribute'><code>ncdfCF::CFObject$set_attribute()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="write_attributes"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-write_attributes'><code>ncdfCF::CFObject$write_attributes()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFBounds-new"></a>}}
\if{latex}{\out{\hypertarget{method-CFBounds-new}{}}}
\subsection{Method \code{new()}}{
Create an instance of this class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFBounds$new(nc_var, nc_dim, values)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{nc_var}}{The NC variable that describes this instance.}

\item{\code{nc_dim}}{The NC dimension that defines the vertices of the bounds.}

\item{\code{values}}{A matrix with the bounds values.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFBounds-print"></a>}}
\if{latex}{\out{\hypertarget{method-CFBounds-print}{}}}
\subsection{Method \code{print()}}{
Print a summary of the object to the console.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFBounds$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Arguments passed on to other functions. Of particular interest
is \verb{width = } to indicate a maximum width of attribute columns.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFBounds-range"></a>}}
\if{latex}{\out{\hypertarget{method-CFBounds-range}{}}}
\subsection{Method \code{range()}}{
Retrieve the lowest and highest value in the bounds.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFBounds$range()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFBounds-sub_bounds"></a>}}
\if{latex}{\out{\hypertarget{method-CFBounds-sub_bounds}{}}}
\subsection{Method \code{sub_bounds()}}{
Return bounds spanning a smaller dimension range.

This method returns bounds which spans the range of indices given by
the \code{rng} argument.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFBounds$sub_bounds(group, rng)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{group}}{The group to create the new bounds in.}

\item{\code{rng}}{The range of values from this bounds object to include in the
returned object.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{CFBounds} instance covering the indicated range of indices.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFBounds-write"></a>}}
\if{latex}{\out{\hypertarget{method-CFBounds-write}{}}}
\subsection{Method \code{write()}}{
Write the bounds variable to a netCDF file. This method
should not be called directly; instead, \code{CFArray::save()} will call this
method automatically.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFBounds$write(h, object_name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{h}}{The handle to a netCDF file open for writing.}

\item{\code{object_name}}{The name of the object that uses these bounds, usually
an axis but could also be an auxiliary CV or a parametric Z axis.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFBounds-clone"></a>}}
\if{latex}{\out{\hypertarget{method-CFBounds-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFBounds$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
