% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcR.R
\name{estimateRtAvg}
\alias{estimateRtAvg}
\title{Estimates the average effective reproductive number}
\usage{
estimateRtAvg(rtData, rangeForAvg = NULL)
}
\arguments{
\item{rtData}{The name of the dateset with time-level reproductive numbers.}

\item{rangeForAvg}{A vector with the start and ending time period to be used to calculate the
average effective reproductive number.}
}
\value{
A data frame with the average effective reproductive. Column names:
     \itemize{
       \item \code{RtAvg} - the average time-level reproductive number between the range
        specified in \code{rangeForAvg}.
     }
}
\description{
Averages the time-level reproductive numbers within a certain range to estimate the overall
reproductive number for an oubreak.
}
\details{
This function is meant to be called by \code{\link{estimateR}}
which estimates the individual-level and time-level, and average reproductive numbers,
but it can also be run directly.
}
\seealso{
\code{\link{estimateR}} \code{\link{estimateRi}} \code{\link{estimateRt}}
}
