% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neuronlist.R
\name{plot3d.neuronlist}
\alias{plot3d.character}
\alias{plot3d.neuronlist}
\title{3D plots of the elements in a neuronlist, optionally using a subset 
expression}
\usage{
\method{plot3d}{neuronlist}(x, subset = NULL, col = NULL,
  colpal = rainbow, skipRedraw = ifelse(interactive(), 200L, TRUE),
  WithNodes = FALSE, soma = FALSE, ..., SUBSTITUTE = TRUE)

\method{plot3d}{character}(x, db = NULL, ...)
}
\arguments{
\item{x}{a neuron list or, for \code{plot3d.character}, a character vector of
neuron names. The default neuronlist used by plot3d.character can be set by
using \code{options(nat.default.neuronlist='mylist')}. See 
?\code{\link{nat}} for details. \code{\link{nat-package}}.}

\item{subset}{Expression evaluating to logical mask for neurons. See details.}

\item{col}{An expression specifying a colour evaluated in the context of the 
dataframe attached to nl (after any subsetting). See details.}

\item{colpal}{A vector of colours or a function that generates colours}

\item{skipRedraw}{When plotting more than this many (default 200) neurons 
skip redraw for individual neurons (this is much faster for large number of
neurons). Can also accept logical values TRUE (always skip) FALSE (never 
skip).}

\item{WithNodes}{Whether to plot points for end/branch points. Default: 
\code{FALSE}.}

\item{soma}{Whether to plot a sphere at neuron's origin representing the 
soma. Either a logical value or a numeric indicating the radius (default 
\code{FALSE}). When \code{soma=TRUE} the radius is hard coded to 2.}

\item{...}{options passed on to plot3d (such as colours, line width etc)}

\item{SUBSTITUTE}{Whether to \code{substitute} the expressions passed as 
arguments \code{subset} and \code{col}. Default: \code{TRUE}. For expert 
use only, when calling from another function.}

\item{db}{A neuronlist to use as the source of objects to plot. If
\code{NULL}, the default, will use the neuronlist specified by
options('nat.default.neuronlist')}
}
\value{
list of values of \code{plot3d} with subsetted dataframe as attribute
  \code{'df'}
}
\description{
3D plots of the elements in a neuronlist, optionally using a subset 
expression

\code{plot3d.character} is a convenience method intended for 
  exploratory work on the command line.
}
\details{
The col and subset parameters are evaluated in the context of the 
  dataframe attribute of the neuronlist. If col evaluates to a factor and 
  colpal is a named vector then colours will be assigned by matching factor 
  levels against the named elements of colpal. If there is one unnamed level,
  this will be used as catch-all default value (see examples).
  
  If col evaluates to a factor and colpal is a function then it will be used 
  to generate colours with the same number of levels as are used in col.
  
  WithNodes is \code{FALSE} by default when using \code{plot3d.neuronlist} 
  but remains \code{TRUE} by default when plotting single neurons with 
  \code{\link{plot3d.neuron}}. This is because the nodes quickly make plots 
  with multiple neurons rather busy.
  
  When \code{soma} is \code{TRUE} or a vector of numeric values (recycled as 
  appropriate), the values are used to plot cell bodies. For neurons the 
  values are passed to \code{plot3d.neuron} for neurons. In contrast 
  \code{dotprops} objects still need special handling. There must be columns 
  called \code{X,Y,Z} in the data.frame attached to \code{x}, that are then 
  used directly by code in \code{plot3d.neuronlist}.
  
  Whenever plot3d.neuronlist is called, it will add an entry to an 
  environment \code{.plotted3d} in \code{nat} that stores the ids of all the 
  plotted shapes (neurons, cell bodies) so that they can then be removed by a
  call to \code{npop3d}.

plot3d.character will check if options('nat.default.neuronlist') has
  been set and then use x as an identifier to find a neuron in that 
  neuronlist.
}
\examples{
open3d()
plot3d(kcs20,type=='gamma',col='green')
\donttest{
clear3d()
plot3d(kcs20,col=type)
plot3d(Cell07PNs,Glomerulus=="DA1",col='red')
plot3d(Cell07PNs,Glomerulus=="VA1d",col='green')
# Note use of default colour for non DA1 neurons
plot3d(Cell07PNs,col=Glomerulus, colpal=c(DA1='red', 'grey'))
# a subset expression
plot3d(Cell07PNs,Glomerulus\%in\%c("DA1",'VA1d'),
  col=c("red","green")[factor(Glomerulus)])
# the same but not specifying colours explicitly
plot3d(Cell07PNs,Glomerulus\%in\%c("DA1",'VA1d'),col=Glomerulus)
}
\dontrun{
## more complex colouring strategies for a larger neuron set
# see https://github.com/jefferis/frulhns for details
library(frulhns)
# notice the sexually dimorphic projection patterns for these neurons
plot3d(jkn,cluster=='aSP-f' &shortGenotype=='JK1029', 
  col=sex,colpal=c(male='green',female='magenta'))

## colour neurons of a class by input resistance
jkn.aspg=subset(jkn, cluster=='aSP-g')
# NB this comes in as a factor
Ri=with(jkn.aspg,as.numeric(as.character(Ri..GOhm.)))
# the matlab jet palette
jet.colors<-colorRampPalette(c('navy','cyan','yellow','red'))
plot3d(jkn.aspg,col=cut(Ri,20),colpal=jet.colors)
}
}
\seealso{
\code{\link{nat-package}}
}

