% Generated by roxygen2 (4.0.2): do not edit by hand
\name{xform_brain}
\alias{xform_brain}
\title{Transform 3D object between template brains}
\usage{
xform_brain(x, sample, reference, via = NULL, ...)
}
\arguments{
\item{x}{the 3D object to be transformed}

\item{sample}{source template brain (e.g. IS2) that data is currently in.}

\item{reference}{target template brain (e.g. IS2) that data should be
transformed into.}

\item{via}{optional intermediate brain to use when there is no direct
bridging registration.}

\item{...}{extra arguments to pass to \code{\link[nat]{xform}}.}
}
\description{
Transform 3D object between template brains
}
\details{
NB the sample and reference brains can either be
  \code{templatebrain} objects or a character string containing the short
  name of the template e.g. \code{"IS2"}.
}
\examples{
## depends on nat.flybrains package and system CMTK installation
\dontrun{
library(nat.flybrains)
# Plot Kenyon cells in their original FCWB template brain
nopen3d()
plot3d(kcs20)
plot3d(FCWB)
# Convert to JFCR2 template brain
kcs20.jfrc2=xform_brain(kcs20, sample = FCWB, reference=JFRC2, .progress='text')
# now plot in the new JFRC2 space
nopen3d()
plot3d(kcs20.jfrc2)
plot3d(JFRC2)
# compare with the untransformed neurons
plot3d(kcs20)
# plot with neuropil sub regions for the left mushroom body
clear3d()
plot3d(kcs20.jfrc2)
# nb "MB.*_L" is a regular expression
plot3d(JFRC2NP.surf, "MB.*_L", alpha=0.3)
# compare with originals - briging registration is no perfect in peduncle
nopen3d()
plot3d(kcs20)
plot3d(FCWBNP.surf, "MB.*_L", alpha=0.3)

}
}

