% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nano.R
\name{nano}
\alias{nano}
\title{Create Nano Object}
\usage{
nano(
  protocol = c("bus", "pair", "push", "pull", "pub", "sub", "req", "rep", "surveyor",
    "respondent"),
  dial = NULL,
  listen = NULL,
  tls = NULL,
  autostart = TRUE
)
}
\arguments{
\item{protocol}{[default 'bus'] choose protocol - \sQuote{bus}, \sQuote{pair},
\sQuote{poly}, \sQuote{push}, \sQuote{pull}, \sQuote{pub}, \sQuote{sub},
\sQuote{req}, \sQuote{rep}, \sQuote{surveyor}, or \sQuote{respondent} - see
\link{protocols}.}

\item{dial}{(optional) a URL to dial, specifying the transport and address as
a character string e.g. 'inproc://anyvalue' or 'tcp://127.0.0.1:5555' (see
\link{transports}).}

\item{listen}{(optional) a URL to listen at, specifying the transport and
address as a character string e.g. 'inproc://anyvalue' or
'tcp://127.0.0.1:5555' (see \link{transports}).}

\item{tls}{[default NULL] for secure tls+tcp:// or wss:// connections only,
provide a TLS configuration object created by \code{\link{tls_config}}.}

\item{autostart}{[default TRUE] whether to start the dialer/listener. Set to
FALSE if setting configuration options on the dialer/listener as it is not
generally possible to change these once started. For dialers only: set to
NA to start synchronously - this is less resilient if a connection is not
immediately possible, but avoids subtle errors from attempting to use the
socket before an asynchronous dial has completed.}
}
\value{
A nano object of class \sQuote{nanoObject}.
}
\description{
Create a nano object, encapsulating a Socket, Dialers/Listeners and
associated methods.
}
\details{
This function encapsulates a Socket, Dialer and/or Listener, and its
associated methods.

The Socket may be accessed by \code{$socket}, and the Dialer or Listener by
\code{$dialer[[1]]} or \code{$listener[[1]]} respectively.

The object's methods may be accessed by \code{$} e.g. \code{$send()} or
\code{$recv()}. These methods mirror their functional equivalents, with the
same arguments and defaults, apart from that the first argument of the
functional equivalent is mapped to the object's encapsulated socket (or
context, if active) and does not need to be supplied.

More complex network topologies may be created by binding further dialers or
listeners using the object's \code{$dial()} and \code{$listen()} methods. The
new dialer/listener will be attached to the object e.g. if the object already
has a dialer, then at \code{$dialer[[2]]} etc.

Note that \code{$dialer_opt()} and \code{$listener_opt()} methods will be
available once dialers/listeners are attached to the object. These methods
get or apply settings for all dialers or listeners equally. To get or apply
settings for individual dialers/listeners, access them directly via
\code{$dialer[[2]]} or \code{$listener[[2]]} etc.

The methods \code{$opt()}, and also \code{$dialer_opt()} or
\code{$listener_opt()} as may be applicable, will get the requested option if
a single argument 'name' is provided, and will set the value for the option
if both arguments 'name' and 'value' are provided.

For Dialers or Listeners not automatically started, the
\code{$dialer_start()} or  \code{$listener_start()} methods will be
available. These act on the most recently created Dialer or Listener
respectively.

For applicable protocols, new contexts may be created by using the
\code{$context_open()} method. This will attach a new context at
\code{$context} as well as a \code{$context_close()} method. While a context
is active, all object methods use the context rather than the socket. A new
context may be created by calling \code{$context_open()}, which will replace
any existing context. It is only necessary to use \code{$context_close()} to
close the existing context and revert to using the socket.
}
\examples{
nano <- nano("bus", listen = "inproc://nanonext")
nano
nano$socket
nano$listener[[1]]

nano$opt("send-timeout", 1500)
nano$opt("send-timeout")

nano$listen(url = "inproc://nanonextgen")
nano$listener

nano1 <- nano("bus", dial = "inproc://nanonext")
nano$send("example test", mode = "raw")
nano1$recv("character")

nano$close()
nano1$close()

}
