% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miss-x-span.R
\name{miss_var_span}
\alias{miss_var_span}
\title{Summarise the number of missings for a given repeating span on a variable}
\usage{
miss_var_span(data, var, span_every)
}
\arguments{
\item{data}{data.frame}

\item{var}{variable of interest. Currently just one variable}

\item{span_every}{integer describing the length of the span to be explored}
}
\value{
dataframe with variables \code{n_miss}, \code{n_complete}, \code{prop_miss}, and
\code{prop_complete}, which describe the number, or proportion of missing or
complete values within that given time span.
}
\description{
To summarise the missing values in a time series object it can be useful to
calculate the number of missing values in a given time period.
\code{miss_var_span} takes a data.frame object, a variable, and a \code{span_every}
argument and returns a dataframe containing the number of missing values
within each span.
}
\examples{

miss_var_span(data = pedestrian,
             var = hourly_counts,
             span_every = 168)

 library(dplyr)
 pedestrian \%>\%
   group_by(month) \%>\%
     miss_var_span(var = hourly_counts,
                   span_every = 168)

}
