% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\name{europeana_read}
\alias{europeana_read}
\title{Read Europeana Newspaper data}
\usage{
europeana_read(x)
}
\arguments{
\item{x}{path to the file}
}
\value{
a data.frame with columns doc_id, sentence_id, token, entity
}
\description{
Read Europeana Newspaper data. Data is made available at \url{https://github.com/EuropeanaNewspapers/ner-corpora} under the CC0 license.
}
\examples{
r <- "https://raw.githubusercontent.com/EuropeanaNewspapers/ner-corpora/master"
\donttest{
x <- file.path(r, "enp_NL.kb.bio", "enp_NL.kb.bio")
x <- europeana_read(x)
x <- file.path(r, "enp_FR.bnf.bio", "enp_FR.bnf.bio")
x <- europeana_read(x)
x <- file.path(r, "enp_DE.sbb.bio", "enp_DE.sbb.bio")
x <- europeana_read(x)
x <- file.path(r, "enp_DE.onb.bio", "enp_DE.onb.bio")
x <- europeana_read(x)
x <- file.path(r, "enp_DE.lft.bio", "enp_DE.lft.bio")
x <- europeana_read(x)
}
}
