% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nLTTDiff.R
\name{nltt_diff}
\alias{nltt_diff}
\title{Calculates the exact difference between the lineage through time curves of tree1 & tree2 (normalized in time and for the number of lineages)}
\usage{
nltt_diff(tree1, tree2, distance_method = "abs", ignore_stem = TRUE,
  log_transform = FALSE)
}
\arguments{
\item{tree1}{(phylo) First phylogenetic tree}

\item{tree2}{(phylo) Second phylogenetic tree}

\item{distance_method}{(string) absolute, or squared distance?}

\item{ignore_stem}{logical    Should the phylogeny its stem be ignored?}

\item{log_transform}{(logical) Should the number of lineages be
log-transformed before normalization?}
}
\value{
(scalar) normalized Lineage-Through-Time difference
  between tree1 & tree2
}
\description{
Calculates the exact difference between the lineage through time curves of tree1 & tree2 (normalized in time and for the number of lineages)
}
\seealso{
use \code{\link{nltts_diff}} to compare a collection of
  phylogenies to one focal/reference tree
}
\author{
Thijs Janzen
}
