\name{parallel}
\alias{parallel}

\title{ Parallel Analysis of a Correlation or Covariance Matrix}

\description{
  This function gives the distribution of the eigenvalues of correlation or a covariance
  matrices of random uncorrelated standardized normal variables. The mean 
  and a selected quantile of this distribution are returned.
 }

\usage{
 parallel(subject  = 100,
          var      = 10,
          rep      = 100,
          cent     = 0.05,
          quantile = cent,
          model    = "components",
          sd       = diag(1,var),
          ...)
 }

\arguments{
  \item{subject}{    numeric: nmber of subjects (default is 100)}
  \item{var}{        numeric: number of variables (default is 10) }
  \item{rep}{        numeric: number of replications of the correlation matrix
                     (default is 100)}
  \item{cent}{       depreciated numeric (use quantile instead): quantile of the
                     distribution on which the decision is made (default is 0.05)}
  \item{quantile}{   numeric: quantile of the distribution on which the decision
                     is made (default is 0.05)}
  \item{model}{      character: \code{"components"} or \code{"factors"} }
  \item{sd}{         numeric: vector of standard deviations of the simulated variables
                     (for a parallel analysis on a covariance matrix) }
  \item{...}{        variable: other parameters for the \code{"mvrnorm"}, \code{corr} or
                     \code{cov} functions }
 }
 
\details{
  Note that if the decision is based on a quantile value rather than on the mean, care must
  be taken with the number of replications (\code{rep}). In fact, the smaller the quantile (\code{cent}),
  the bigger the number of necessary replications.
 }


\value{
  \item{eigen}{         Data frame consisting of the mean and the quantile of the eigenvalues distribution }
  \item{eigen$mevpea}{  Mean of the eigenvalues distribution}
  \item{eigen$sevpea}{  Standard deviation of the eigenvalues distribution}  
  \item{eigen$qevpea}{  quantile of the eigenvalues distribution}
  \item{eigen$sqevpea}{ Standard error of the quantile of the eigenvalues distribution}
  \item{subject}{       Number of subjects}
  \item{variables}{     Number of variables}
  \item{centile}{       Selected quantile}
  Otherwise, returns a summary of the parallel analysis.
 }
 
\references{
  Drasgow, F. and Lissak, R. (1983) Modified parallel analysis: a procedure for
   examining the latent dimensionality of dichotomously
   scored item responses. \emph{Journal of Applied Psychology, 68}(3), 363-373.

  Hoyle, R. H. and Duvall, J. L. (2004). Determining the number of factors in
   exploratory and confirmatory factor analysis.
   In D. Kaplan (Ed.): \emph{The Sage handbook of quantitative methodology for
   the social sciences}. Thousand Oaks, CA: Sage.

  Horn, J. L. (1965). A rationale and test of the number of factors in factor
   analysis. \emph{Psychometrika, 30}, 179-185.
 }

\author{ 
    Gilles Raiche \cr
    Centre sur les Applications des Modeles de Reponses aux Items (CAMRI) \cr
    Universite du Quebec a Montreal\cr
    \email{raiche.gilles@uqam.ca}, \url{http://www.er.uqam.ca/nobel/r17165/}
 }

\seealso{
 \code{\link{plotuScree}},
 \code{\link{nScree}},
 \code{\link{plotnScree}},
 \code{\link{plotParallel}}
 }

\examples{
## SIMPLE EXAMPLE OF A PARALLEL ANALYSIS
## OF A CORRELATION MATRIX WITH ITS PLOT
 data(dFactors)
 eig      <- dFactors$Raiche$eigenvalues
 subject  <- dFactors$Raiche$nsubjects
 var      <- length(eig)
 rep      <- 100
 quantile <- 0.95
 results  <- parallel(subject, var, rep, quantile)

 results

## IF THE DECISION IS BASED ON THE CENTILE USE qevpea INSTEAD
## OF mevpea ON THE FIRST LINE OF THE FOLLOWING CALL
 plotuScree(x    = eig,
            main = "Parallel Analysis"
            )
            
 lines(1:var,
       results$eigen$qevpea,
       type="b",
       col="green"
       )


## ANOTHER SOLUTION IS SIMPLY TO
 plotParallel(results)
 }

\keyword{ multivariate }

