% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{mc_read_tubedb}
\alias{mc_read_tubedb}
\title{Reading data from TubeDB}
\usage{
mc_read_tubedb(
  tubedb,
  region = NULL,
  plot = NULL,
  sensor_ids = NULL,
  clean = TRUE,
  silent = FALSE,
  aggregation = "raw",
  quality = "no",
  ...
)
}
\arguments{
\item{tubedb}{object for connection to server see \link[rTubeDB:TubeDB-class]{rTubeDB::TubeDB}}

\item{region}{vector of TubeDB region ids - see \link[rTubeDB:query_regions]{rTubeDB::query_regions} (default NULL)

Regions are used mainly for loading metadata from TubeDB localities.}

\item{plot}{vector of localities ids see \link[rTubeDB:query_region_plots]{rTubeDB::query_region_plots} \link[rTubeDB:query_timeseries]{rTubeDB::query_timeseries} (default NULL)

If plot is NULL, then all localities are loaded from whole region.}

\item{sensor_ids}{list in format \code{list(tubedb_sensor_name=myClim_sensor_name)} (default NULL)
If sensor names in TubeDB match the default sensor names in myClim, then the value is detected automatically.}

\item{clean}{if TRUE, then \link{mc_prep_clean} is called automatically while reading (default TRUE)}

\item{silent}{if TRUE, then any information is not printed in console (default FALSE)}

\item{aggregation}{parameter used in function \link[rTubeDB:query_timeseries]{rTubeDB::query_timeseries} (default raw)}

\item{quality}{parameter used in function \link[rTubeDB:query_timeseries]{rTubeDB::query_timeseries} (default no)}

\item{...}{other parameters from function \link[rTubeDB:query_timeseries]{rTubeDB::query_timeseries}}
}
\value{
myClim object in Raw-format
}
\description{
Function is reading data from TubeDB (https://environmentalinformatics-marburg.github.io/tubedb/) into myClim object.
}
\details{
In case you store your microclimatic time-series in TubeDB, you can read data
with TubeDB API into myClim object. You need to know database URL, username and password.
}
\examples{
# Not run: To retrieve data from TubeDB, a running TubeDB server with a user account
#          and a secret password is required.
\dontrun{
tubedb <- TubeDB(url="server", user="user", password="password")
data <- mc_read_tubedb(tubedb, region="ckras", plot=c("TP_KAR_19", "TP_KODA_61"))
}
}
