% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_individual_algebra_results.R
\name{get_individual_algebra_results}
\alias{get_individual_algebra_results}
\title{get_individual_algebra_results}
\usage{
get_individual_algebra_results(
  mxModel,
  algebra_names = NULL,
  progress_bar = TRUE
)
}
\arguments{
\item{mxModel}{mxModel with algebras}

\item{algebra_names}{optional: Only compute individual algebras for a subset
of the parameters}

\item{progress_bar}{should a progress bar be shown?}
}
\value{
a list of data frames. The list contains data frames for each of the algebras.
The data frames contain the individual specific algebra results as well as all
definition variables used to predict said algebra
}
\description{
evaluates algebras for each subject in the data set. This function is
useful if you have algebras with definition variables (e.g., in mnlfa).
}
\examples{
library(mxsem)

set.seed(123)
dataset <- simulate_moderated_nonlinear_factor_analysis(N = 50)

model <- "
  xi  =~ x1 + x2 + x3
  eta =~ y1 + y2 + y3
  eta ~  {a := a0 + data.k*a1}*xi
  "
fit <- mxsem(model = model,
             data = dataset) |>
  mxTryHard()

algebra_results <- get_individual_algebra_results(mxModel = fit,
                                                  progress_bar = FALSE)

# the following plot will only show two data points because there is only
# two values for the definition variable k (0 or 1).

plot(x = algebra_results[["a"]]$k,
     y = algebra_results[["a"]]$algebra_result)
}
