/*
 * Decompiled with CFR 0.152.
 */
package ru.itmo.ctlab.virgo.gmwcs.graph.flow;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.itmo.ctlab.virgo.Pair;
import ru.itmo.ctlab.virgo.gmwcs.graph.flow.MaxFlow;

public class EdmondsKarp
implements MaxFlow {
    private int n;
    private List<List<Integer>> adj;
    private List<List<Integer>> backIndex;
    private List<List<Double>> capacity;
    private List<Map<Integer, Integer>> indices;

    public EdmondsKarp(int n) {
        this.n = n;
        this.adj = new ArrayList<List<Integer>>();
        this.backIndex = new ArrayList<List<Integer>>(n);
        this.capacity = new ArrayList<List<Double>>(n);
        this.indices = new ArrayList<Map<Integer, Integer>>(n);
        for (int i = 0; i < n; ++i) {
            this.adj.add(new ArrayList());
            this.backIndex.add(new ArrayList());
            this.capacity.add(new ArrayList());
            this.indices.add(new HashMap());
        }
    }

    private void addSingleEdge(int i, int j) {
        this.adj.get(i).add(j);
        this.backIndex.get(i).add(-1);
        this.capacity.get(i).add(0.0);
        this.indices.get(i).put(j, this.adj.get(i).size() - 1);
    }

    @Override
    public void addEdge(int i, int j) {
        if (this.indices.get(i).containsKey(j)) {
            return;
        }
        this.addSingleEdge(i, j);
        this.addSingleEdge(j, i);
        this.backIndex.get(i).set(this.backIndex.get(i).size() - 1, this.adj.get(j).size() - 1);
        this.backIndex.get(j).set(this.backIndex.get(j).size() - 1, this.adj.get(i).size() - 1);
    }

    @Override
    public void setCapacity(int i, int j, double c) {
        this.capacity.get(i).set(this.indices.get(i).get(j), c);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public List<Pair<Integer, Integer>> computeMinCut(int s, int t, double threshold) {
        ArrayList<List<Double>> flow = new ArrayList<List<Double>>(this.n);
        for (int i = 0; i < this.n; ++i) {
            flow.add(new ArrayList());
            for (int j = 0; j < this.adj.get(i).size(); ++j) {
                ((List)flow.get(i)).add(0.0);
            }
        }
        double maxFlow = 0.0;
        block2: while (!(maxFlow >= threshold)) {
            ArrayList<Integer> parent = new ArrayList<Integer>(this.n);
            ArrayList<Integer> parentIndex = new ArrayList<Integer>(this.n);
            ArrayList<Double> min = new ArrayList<Double>(this.n);
            for (int i = 0; i < this.n; ++i) {
                parent.add(-1);
                parentIndex.add(-1);
                min.add(Double.POSITIVE_INFINITY);
            }
            ArrayDeque<Integer> q = new ArrayDeque<Integer>();
            q.add(s);
            block4: while (true) {
                if (q.isEmpty()) {
                    return this.getResult(s, flow);
                }
                int v = (Integer)q.poll();
                int i = 0;
                while (true) {
                    if (i >= this.adj.get(v).size()) continue block4;
                    int u = this.adj.get(v).get(i);
                    if (this.rcap(flow, v, i) > 0.0) {
                        if ((Double)min.get(u) == Double.POSITIVE_INFINITY) {
                            min.set(u, Math.min((Double)min.get(v), this.rcap(flow, v, i)));
                            q.add(u);
                            parent.set(u, v);
                            parentIndex.set(u, i);
                        }
                        if (u == t) {
                            int k = t;
                            double f = (Double)min.get(t);
                            while (true) {
                                if (k == s) continue block2;
                                int p = (Integer)parent.get(k);
                                int pi = (Integer)parentIndex.get(k);
                                this.push(p, pi, f, flow);
                                k = p;
                            }
                        }
                    }
                    ++i;
                }
                break;
            }
            break;
        }
        return null;
    }

    private List<Pair<Integer, Integer>> getResult(int s, List<List<Double>> flow) {
        ArrayList<Boolean> vis = new ArrayList<Boolean>(this.n);
        for (int i = 0; i < this.n; ++i) {
            vis.add(false);
        }
        this.dfs(s, vis, flow);
        ArrayList<Pair<Integer, Integer>> res = new ArrayList<Pair<Integer, Integer>>();
        for (int v = 0; v < this.n; ++v) {
            if (!((Boolean)vis.get(v)).booleanValue()) continue;
            for (int u : this.adj.get(v)) {
                if (((Boolean)vis.get(u)).booleanValue()) continue;
                res.add(new Pair<Integer, Integer>(v, u));
            }
        }
        return res;
    }

    private void dfs(int v, List<Boolean> vis, List<List<Double>> flow) {
        vis.set(v, true);
        for (int j = 0; j < this.adj.get(v).size(); ++j) {
            int u = this.adj.get(v).get(j);
            if (vis.get(u).booleanValue() || !(this.rcap(flow, v, j) > 0.0)) continue;
            this.dfs(u, vis, flow);
        }
    }

    private double rcap(List<List<Double>> flow, int v, int i) {
        double res = 0.0;
        int u = this.adj.get(v).get(i);
        int j = this.backIndex.get(v).get(i);
        if (this.backIndex.get(v).get(i) != -1) {
            res += flow.get(u).get(j).doubleValue();
        }
        return res + this.capacity.get(v).get(i) - flow.get(v).get(i);
    }

    private void push(int v, int i, double cap, List<List<Double>> flow) {
        int u = this.adj.get(v).get(i);
        int j = this.backIndex.get(v).get(i);
        if (j != -1) {
            double can = Math.min(cap, flow.get(u).get(j));
            flow.get(u).set(j, flow.get(u).get(j) - can);
            cap -= can;
        }
        if (cap > 0.0) {
            flow.get(v).set(i, flow.get(v).get(i) + cap);
        }
    }
}

