% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/censored_likelihood.R
\name{censoredLikelihood}
\alias{censoredLikelihood}
\title{Censored log-likelihood function}
\usage{
censoredLikelihood(obs, loc, vario, u, p = 499, vec = c(1, 209, 109, 191,
  67, 51, 120, 93, 87, 157, 178, 45, 137, 84, 198, 61, 232, 113, 182, 150, 57,
  169, 141, 79, 132, 163, 38, 85, 131, 106, 96, 165, 233, 179, 32, 228, 73, 233,
  96, 131, 147, 32, 179, 165, 179, 228, 32, 147, 165, 106, 228, 32, 179, 131,
  32, 131, 228, 179, 106, 165, 147, 179, 106, 147, 228, 165, 165, 179, 147, 228,
  106, 106, 32, 228, 147, 179, 32, 228, 106, 147, 32, 147, 228, 106, 179, 106,
  179, 228, 32, 147, 179, 32, 228, 106, 147, 147, 106, 179, 228, 32, 106, 228,
  147, 179, 32, 228,      147, 32, 179, 106, 32, 106, 179, 147, 147, 179, 228,
  106, 32, 106, 228, 179, 32, 147, 228, 179, 106, 32, 147, 228, 106, 179, 32,
  106, 147, 228, 179, 32, 228, 106, 179, 147, 32, 147, 179, 106, 228, 106, 179,
  147, 228, 32, 228, 179, 147, 106, 147, 32, 179, 179, 179, 179, 179, 179, 179,
  179, 179, 179, 179, 179, 179, 179, 179, 179, 179, 179, 179, 179, 179, 179,
  179, 179, 179, 179, 179, 179, 179, 179, 179, 179, 179, 179, 179, 179, 179,
  179, 179, 179, 179, 179, 179, 179, 179, 179, 179, 179, 179, 179,      179,
  179, 179, 179, 179, 179, 179, 179, 179, 179, 179, 179, 179, 179, 179, 179,
  179, 179, 179, 179, 179, 179, 179, 179, 179, 179, 179, 179, 179, 179, 179,
  179, 179, 179, 179, 179, 179, 179, 179, 179, 179, 179, 179, 179, 179, 179,
  179, 179, 179, 179, 179, 179, 179, 179, 179, 179, 179, 179, 179, 179, 179,
  179, 179, 179, 179, 179, 179, 179, 179, 179, 179, 179, 179, 179, 179, 179,
  179, 179, 179, 179, 179, 179, 179, 179, 179, 179, 179, 179, 179, 179, 179,
  179)/499, nCores = 1, cl = NULL)
}
\arguments{
\item{obs}{List of vectors for which at least one component exceeds a high threshold.}

\item{loc}{Matrix of coordinates as given by \code{expand.grid()}.}

\item{vario}{Semi-variogram function taking a vector of coordinates as input.}

\item{u}{Vector of thresholds for censoring components.}

\item{p}{Number of samples used for quasi-Monte carlo estimation. Must be a prime number.}

\item{vec}{Generating vector for the quasi-Monte Carlo procedure. For a given \code{p} and dimensionality,
can be computed using \code{genVecQMC}.}

\item{nCores}{Number of cores used for the computation}

\item{cl}{Cluster instance as created by \code{makeCluster} of the \code{parallel} package.}
}
\value{
Evaluation of the censored log-likelihood function for the set of observations \code{obs} and semi-variogram \code{vario}.
}
\description{
Compute the peaks-over-threhold censored log-likelihood function for the Brown--Resnick model.
}
\details{
The function computes the censored log-likelihood function based on the representation
developped by Waddsworth et al. (2013) and Engelelke et al. (2015). Margins must have been
standardized, for instance to unit Frechet.
}
\examples{
#Define semi-variogram function
vario <- function(h){
   1 / 2 * norm(h,type = "2")^1.5
}

#Define locations
loc <- expand.grid(1:4, 1:4)

#Simulate data
obs <- simulPareto(1000, loc, vario)

#Evaluate risk functional
maxima <- sapply(obs, max)
thres <- quantile(maxima, 0.9)

#Select exceedances
exceedances <- obs[maxima > thres]

#Compute generating vector
p <- 499
vec <- genVecQMC(p, nrow(loc))

#Compute log-likelihood function
censoredLikelihood(exceedances, loc, vario, rep(thres, nrow(loc)), p, vec)
}
\references{
Wadsworth, J.L. and Tawn, J.A. (2013). Efficient Inference for Spatial Extreme Value Processes Associated to Log-Gaussian Random Function. Biometrika, 101(1):1-15.

            Asadi, P., Davison A. C. and Engelke, S. (2016). Extremes on River Networks. Annals of Applied Statistics, to appear.
}

