/*
 * Decompiled with CFR 0.152.
 */
package af.statguitoolkit.gui.datatable;

import af.statguitoolkit.gui.datatable.CellEditor;
import af.statguitoolkit.gui.datatable.CellRenderer;
import af.statguitoolkit.gui.datatable.CellValue;
import af.statguitoolkit.gui.datatable.DataTableModel;
import af.statguitoolkit.gui.datatable.DataTablePopup;
import af.statguitoolkit.gui.datatable.HeaderCellValue;
import af.statguitoolkit.gui.datatable.HeaderPopup;
import af.statguitoolkit.gui.datatable.HeaderRenderer;
import af.statguitoolkit.gui.datatable.JXTable2;
import java.awt.Color;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.af.commons.Localizer;
import org.af.jhlir.call.RDataFrame;
import org.af.jhlir.call.RVectorFactor;

public class DataTable
extends JXTable2 {
    public static final Color NUM_COLOR = Color.BLUE;
    public static final Color INT_COLOR = new Color(0, 155, 0);
    public static final Color FACTOR_COLOR = Color.RED;
    public static final Color CHAR_COLOR = Color.GREEN;
    public static final Color LOGICAL_COLOR = Color.PINK;

    public DataTable(RDataFrame df) {
        this(new DataTableModel(df));
    }

    public DataTable(DataTableModel dataTableModel) {
        super(dataTableModel);
        this.getTableHeader().setReorderingAllowed(false);
        this.getColumnModel().setColumnSelectionAllowed(false);
        this.setRowSelectionAllowed(false);
        this.setAutoResizeMode(0);
        this.setColumnControlVisible(true);
        this.getTableHeader().setComponentPopupMenu((JPopupMenu)((Object)new HeaderPopup(this)));
        this.setComponentPopupMenu((JPopupMenu)((Object)new DataTablePopup(this)));
        CellRenderer cr = new CellRenderer();
        CellEditor ce = new CellEditor();
        this.setDefaultEditor(CellValue.class, ce);
        this.setDefaultRenderer(CellValue.class, cr);
        this.setTableHeaderRenderer();
    }

    public DataTableModel getModel() {
        return (DataTableModel)super.getModel();
    }

    public void update() {
        this.getModel().fireTableStructureChanged();
    }

    public Dimension getPreferredScrollableViewportSize() {
        Dimension size = super.getPreferredScrollableViewportSize();
        return new Dimension(Math.min(this.getPreferredSize().width, size.width), size.height);
    }

    public boolean getScrollableTracksViewportWidth() {
        return this.getAutoResizeMode() == 0 ? this.getParent().getWidth() > this.getPreferredSize().width : super.getScrollableTracksViewportWidth();
    }

    public String getColumnVar(int col) {
        return this.getModel().getColumnName(col);
    }

    private void setTableHeaderRenderer() {
        TableCellRenderer r = this.getTableHeader().getDefaultRenderer();
        this.getTableHeader().setDefaultRenderer(new HeaderRenderer(r));
    }

    public void createDefaultColumnsFromModel() {
        super.createDefaultColumnsFromModel();
        for (int j = 0; j < this.getColumnCount(); ++j) {
            TableColumn aColumn = this.getColumn(j);
            int i = aColumn.getModelIndex();
            String name = this.getModel().getColumnName(i);
            RVectorFactor dfCol = this.getModel().getDataFrame().getCol(i);
            aColumn.setHeaderValue(new HeaderCellValue(name, dfCol));
        }
    }

    public void addColumn(TableColumn aColumn) {
        int i = aColumn.getModelIndex();
        String name = this.getModel().getColumnName(i);
        RVectorFactor dfCol = this.getModel().getDataFrame().getCol(i);
        aColumn.setHeaderValue(new CellValue(name, dfCol));
        super.addColumn(aColumn);
    }

    public Box getTypeDescriptionComponent() {
        JLabel caption = new JLabel(Localizer.getInstance().getString("SGTK_DATATABLE_DATATABLE_COLORKEY"));
        JLabel numeric = new JLabel(Localizer.getInstance().getString("SGTK_DATATABLE_DATATABLE_NUMERIC"));
        JLabel integer = new JLabel(Localizer.getInstance().getString("SGTK_DATATABLE_DATATABLE_INTEGER"));
        JLabel factor = new JLabel(Localizer.getInstance().getString("SGTK_DATATABLE_DATATABLE_FACTOR"));
        numeric.setForeground(NUM_COLOR);
        integer.setForeground(INT_COLOR);
        factor.setForeground(FACTOR_COLOR);
        Box b = Box.createHorizontalBox();
        b.add(Box.createHorizontalGlue());
        b.add(caption);
        b.add(Box.createHorizontalGlue());
        b.add(numeric);
        b.add(Box.createHorizontalGlue());
        b.add(integer);
        b.add(Box.createHorizontalGlue());
        b.add(factor);
        b.add(Box.createHorizontalGlue());
        return b;
    }
}

