% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.multiview.R
\name{predict.multiview}
\alias{predict.multiview}
\title{Get predictions from a \code{multiview} fit object}
\usage{
\method{predict}{multiview}(
  object,
  newx,
  s = NULL,
  type = c("link", "response", "coefficients", "class", "nonzero"),
  exact = FALSE,
  newoffset,
  ...
)
}
\arguments{
\item{object}{Fitted "multiview" object.}

\item{newx}{list of new matrices for  \code{x} at which predictions are to be
made. Must be a list of matrices. This argument is not used for \code{type = c("coefficients","nonzero")}.}

\item{s}{Value(s) of the penalty parameter lambda at which predictions are
required. Default is the entire sequence used to create the model.}

\item{type}{Type of prediction required. Type "link" gives the linear
predictors (eta scale); Type "response" gives the fitted values (mu scale).
Type "coefficients" computes the coefficients at the requested values for s.
Type "nonzero" returns a list of the indices of the nonzero coefficients for
each value of s. Type "class" returns class labels for binomial family only.}

\item{exact}{This argument is relevant only when predictions are made at values
of \code{s} (\code{lambda}) \emph{different} from those used in the fitting of the
original model. If \code{exact=FALSE} (default), then the predict function
uses linear interpolation to make predictions for values of \code{s} (lambda)
that do not coincide with those used in the fitting algorithm. While this is
often a good approximation, it can sometimes be a bit coarse. With
\code{exact=TRUE}, these different values of \code{s} are merged (and sorted)
with \code{object$lambda}, and the model is refit before predictions are made.
In this case, it is required to supply the original data x= and y= as additional
named arguments to predict() or coef(). The workhorse \code{predict.multiview()}
needs to update the model, and so needs the data used to create it. The same
is true of weights, offset, penalty.factor, lower.limits, upper.limits if
these were used in the original call. Failure to do so will result in an error.}

\item{newoffset}{If an offset is used in the fit, then one must be supplied for
making predictions (except for type="coefficients" or type="nonzero").}

\item{...}{This is the mechanism for passing arguments like \verb{x=} when
\code{exact=TRUE}; see \code{exact} argument.}
}
\value{
The object returned depends on type.
}
\description{
Gives fitted values, linear predictors, coefficients and number of non-zero
coefficients from a fitted \code{multiview} object.
}
\examples{
# Gaussian
x = matrix(rnorm(100 * 20), 100, 20)
z = matrix(rnorm(100 * 20), 100, 20)
y = rnorm(100)
fit1 = multiview(list(x=x,z=z), y, rho = 0)
predict(fit1, newx = list(x[1:10, ],z[1:10, ]), s = c(0.01, 0.005))

# Binomial
by = sample(c(0,1), 100, replace = TRUE)
fit2 = multiview(list(x=x,z=z), by, family = binomial(), rho=0.5)
predict(fit2, newx = list(x[1:10, ],z[1:10, ]), s = c(0.01, 0.005), type = "response")

# Poisson
py = matrix(rpois(100, exp(y))) 
fit3 = multiview(list(x=x,z=z), py, family = poisson(), rho=0.5)
predict(fit3, newx = list(x[1:10, ],z[1:10, ]), s = c(0.01, 0.005), type = "response")

}
