% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiview.path.R
\name{multiview.path}
\alias{multiview.path}
\title{Fit a GLM with elastic net regularization for a path of lambda values}
\usage{
multiview.path(
  x_list,
  y,
  rho = 0,
  weights = NULL,
  mvlambda = NULL,
  nlambda = 100,
  lambda.min.ratio = ifelse(nobs < nvars, 0.01, 1e-04),
  alpha = 1,
  offset = NULL,
  family = gaussian(),
  standardize = TRUE,
  intercept = TRUE,
  thresh = 1e-07,
  maxit = 1e+05,
  penalty.factor = rep(1, nvars),
  exclude = integer(0),
  lower.limits = -Inf,
  upper.limits = Inf,
  trace.it = 0,
  x
)
}
\arguments{
\item{x_list}{a list of \code{x} matrices with same number of rows
\code{nobs}}

\item{y}{the quantitative response with length equal to \code{nobs}, the
(same) number of rows in each \code{x} matrix}

\item{rho}{the weight on the agreement penalty, default 0. \code{rho=0} is a form
of early fusion, and \code{rho=1} is a form of late fusion.}

\item{weights}{observation weights. Can be total counts if
responses are proportion matrices. Default is 1 for each
observation}

\item{mvlambda}{A user supplied \code{lambda} sequence. Typical usage is
to have the program compute its own \code{lambda} sequence based on
\code{nlambda} and \code{lambda.min.ratio}. Supplying a value of \code{lambda}
overrides this. WARNING: use with care. Avoid supplying a single
value for \code{lambda} (for predictions after CV use \code{predict()}
instead).  Supply instead a decreasing sequence of \code{lambda}
values. \code{glmnet} relies on its warms starts for speed, and its
often faster to fit a whole path than compute a single fit.}

\item{nlambda}{The number of lambda values, default is 100.}

\item{lambda.min.ratio}{Smallest value for lambda as a fraction of
lambda.max, the (data derived) entry value (i.e. the smallest
value for which all coefficients are zero). The default depends
on the sample size \code{nobs} relative to the number of variables
\code{nvars}. If \code{nobs >= nvars}, the default is 0.0001, close to
zero. If \code{nobs < nvars}, the default is 0.01.  A very small value
of \code{lambda.min.ratio} will lead to a saturated fit in the \code{nobs < nvars} case. This is undefined for some families of models, and
the function will exit gracefully when the percentage deviance
explained is almost 1.}

\item{alpha}{The elasticnet mixing parameter, with \eqn{0 \le
  \alpha \le 1}.  The penalty is defined as
\deqn{(1-\alpha)/2||\beta||_2^2+\alpha||\beta||_1.}  \code{alpha = 1}
is the lasso penalty, and \code{alpha = 0} the ridge penalty.
\code{lambda.min.ratio}. Supplying a value of lambda overrides this.}

\item{offset}{A vector of length \code{nobs} that is included in the
linear predictor (a \code{nobs} by \code{nc} matrix for the \code{"multinomial"}
family).  Useful for the \code{"poisson"} family (e.g. log of exposure
time), or for refining a model by starting at a current
fit. Default is \code{NULL}. If supplied, then values must also be
supplied to the \code{predict} function.}

\item{family}{A description of the error distribution and link
function to be used in the model. This is the result of a call to
a family function. Default is \link[stats:family]{stats::gaussian}. (See
\link[stats:family]{stats::family} for details on family functions.)}

\item{standardize}{Logical flag for \code{x} variable standardization,
prior to fitting the model sequence. The coefficients are always
returned on the original scale. Default is \code{standardize = TRUE}. If variables are in the same units already, you might not
wish to standardize.}

\item{intercept}{Should intercept be fitted (default \code{TRUE}) or set
to zero (\code{FALSE})?}

\item{thresh}{Convergence threshold for coordinate descent. Each
inner coordinate-descent loop continues until the maximum change
in the objective after any coefficient update is less than thresh
times the null deviance.  Default value is \code{1e-7}.}

\item{maxit}{Maximum number of passes over the data for all lambda
values; default is 10^5.}

\item{penalty.factor}{List of separate penalty factors can be
applied to each coefficient, consisting of \code{ncol(x)} elements for
each \code{x} in \code{x_list}. This is a number that multiplies \code{lambda}
to allow differential shrinkage. Can be 0 for some variables,
which implies no shrinkage, and that variable is always included
in the model. Default is 1 for all variables (and implicitly
infinity for variables listed in \code{exclude}). Note: the penalty
factors are internally rescaled to sum to \code{nvars}.}

\item{exclude}{List of column indices of \code{x} matrices in \code{x_list}
to be excluded from the model. Default is empty list. Equivalent
to an infinite penalty factor for the variables excluded (next
item).  Users can supply instead an \code{exclude()} function that
generates the list of \code{x} columns indices.  This function is most
generally defined as \verb{function(x_list, y, weights, ...)}, and is
called inside \code{\link[=multiview]{multiview()}} to generate the indices for excluded
variables.  The \code{...} argument is required, the others are
optional.  This is useful for filtering wide data, and works
correctly with \code{cv.multiview}.  See the vignette 'Introduction'
for examples.}

\item{lower.limits}{Vector of lower limits for each coefficient
consisting of \verb{ncol(x) elements for each }x\verb{in}x_list\verb{; default }-Inf`. Each of these must be non-positive.}

\item{upper.limits}{Vector of upper limits for each coefficient
consisting of \verb{ncol(x) elements for each }x\verb{in}x_list\verb{; default }Inf`. Each of these must be non-negative.}

\item{trace.it}{If \code{trace.it = 1}, then a progress bar is
displayed; useful for big models that take a long time to fit.}

\item{x}{the cbinded matrices in \code{x_list}}
}
\value{
An object with class "multiview" "glmnetfit" and "glmnet"
\item{a0}{Intercept sequence of length \code{length(lambda)}.}
\item{beta}{A \verb{nvars x length(lambda)} matrix of coefficients, stored in
sparse matrix format.}
\item{df}{The number of nonzero coefficients for each value of lambda.}
\item{dim}{Dimension of coefficient matrix.}
\item{lambda}{The actual sequence of lambda values used. When alpha=0, the
largest lambda reported does not quite give the zero coefficients reported
(lambda=inf would in principle). Instead, the largest lambda for alpha=0.001
is used, and the sequence of lambda values is derived from this.}
\item{mvlambda}{The corresponding sequence of multiview lambda values}
\item{dev.ratio}{The fraction of (null) deviance explained. The deviance
calculations incorporate weights if present in the model. The deviance is
defined to be 2*(loglike_sat - loglike), where loglike_sat is the log-likelihood
for the saturated model (a model with a free parameter per observation).
Hence dev.ratio=1-dev/nulldev.}
\item{nulldev}{Null deviance (per observation). This is defined to be
2*(loglike_sat -loglike(Null)). The null model refers to the intercept model.}
\item{npasses}{Total passes over the data summed over all lambda values.}
\item{jerr}{Error flag, for warnings and errors (largely for internal
debugging).}
\item{offset}{A logical variable indicating whether an offset was included
in the model.}
\item{call}{The call that produced this object.}
\item{family}{Family used for the model.}
\item{nobs}{Number of observations.}
}
\description{
Fit a generalized linear model via penalized maximum likelihood for a path of
lambda values. Can deal with any GLM family.
}
\details{
\code{multiview.path} solves the elastic net problem for a path of lambda values.
It generalizes \code{multiview::multiview} in that it works for any GLM family.

Sometimes the sequence is truncated before \code{nlambda} values of lambda
have been used. This happens when \code{multiview.path} detects that the decrease
in deviance is marginal (i.e. we are near a saturated fit).
}
