\name{Extract.data.list}
\alias{Extract.data.list}
\alias{[.data.list}
\alias{$<-.data.list}
\alias{[[<-.data.list}
\title{Extract or replace parts of a data list}
\description{Operators acting on data list objects to extract or replace parts.}
\usage{
\method{[}{data.list}(x,...,drop=TRUE,vextract=TRUE)
\method{$}{data.list}(x,i) <- value
\method{[[}{data.list}(x,i,match.dimids,drop=TRUE) <- value
}
\arguments{
  \item{x}{A \code{\link{data.list}} object.}
  \item{i}{Subscript or variable name.}
  \item{value}{Replacement value.}
  \item{...}{Vectors to subscript the data list.}
  \item{drop}{If TRUE, single dimension data lists that result from subscripting are coerced to data frames (i.e. their replication dimensions are 'dropped').}
  \item{vextract}{If TRUE, variable extraction is done whenever only a single argument is passed to \code{...}.  If FALSE, variable extraction is not allowed.  Sometimes it is useful to set \code{vextract=FALSE} whenever single-dimension data lists are expecting dimension-wise subscripting.}
  \item{match.dimids}{A character vector supplying the dimids (ids of the replication dimensions) that \code{value} is replicated along, iff \code{i} is a variable name that does not yet exist in the data list, \code{x}}
}
\details{
The \code{[.data.list} method of extraction can be used in two main ways:  (1) to extract parts of the replication dimensions of all of the variables in the data list (modeled after the method for arrays and matrices, \code{\link{Extract}}), and (2) to extract some of the variables while keeping their replication dimensions unaltered (modeled after the method for lists, \code{\link{Extract}}).

In array-like extraction, each replication dimension of the data list is subscripted as an element in a comma-separated list passed to \code{...}.  In intuitive terms, all variables in the data list will be subsequently subscripted along the appropriate replication dimensions; in technical terms, there is a two-step process for each variable where (1) the subscripts for the dimensions that this variable is not replicated along are deleted and then (2) the remaining subscripts are used to index that variable.  This kind of subscripting is one of the major advantages of the data list concept; because the vectors, matrices, and arrays in a data list are related via dimension sharing, they can all be subscripted in a single line.  To emphasize an important point, the main difference between subscripting arrays and array-like subscripting of data lists is that the latter does not allow any dimensions to be either reduced to length zero or be dropped.  In general, the differences between these two types of subscripting are (compare with sections 3.4.1 and 3.4.2 in the R language definition),
\describe{
  \item{Integer}{The special zero index is not allowed with data lists.  This is because it creates dimensions with zero length, which leads to non-sensical data frames that are generated by \code{\link{as.data.frame.data.list}}.  Similarly, any subscripting with negative integers that results in some zero-length dimensions, also causes an error.}
  \item{Other numeric}{Identical to array-like subscripting, with truncation towards zero to integers.}
  \item{Logical}{Identical to array-like subscripting.  Note that logical vectors longer than the dimension to be subscripted result in an error, unless there is only a single dimension in the data list -- in which case, extra NA elements are added as needed (i.e. just as with subscripting of vectors and one-dimensional arrays).}
  \item{Character}{Identical to array-like subscripting.}
  \item{Factor}{Factor subscripting is not allowed with data lists.}
  \item{Empty}{Unlike array-like subscripting, \code{x[]} does not drop any attributes but rather simply returns \code{x}.}
  \item{NULL}{NULL subscripting is not allowed with data lists, for the same reason that zero subscripting is not allowed.}
  \item{Matrix}{Matrices are currently not valid subscripting objects but this could change in the future.}
}

In list-like extraction, only a single subscript vector is used.  A data list with the extracted variables is returned whenever a single subscript vector is used and the input data list has more than one dimension of replication.  By default, a one-dimensional data list is also extracted in a list-like manner whenever a single subscript vector is used; however, this behaviour can be changed by setting \code{vextract = FALSE}, which leads to (one-dimensional-)array-like subscripting.  Whenever the resulting data list is composed of variables that are replicated along fewer dimensions than the original data list, those dimensions are dropped without exception.  If the resulting data list is only replicated along a single dimension, it is coerced to a data frame by default unless \code{drop = FALSE}.  If no variables remain in the resulting data list, then an error is thrown.

The \code{$<-.data.list} and \code{[[<-.data.list} methods of replacement work very much like the default methods \code{\link{$<-}} and \code{\link{[[<-}} for lists, except that they ensure that a valid data list object is returned.  One technical difference between the default and \code{data.list} methods is that new variables cannot be added by passing a new name to \code{i}.  Setting \code{drop = FALSE} in \code{`[[<-`.data.list} ensures that the output will be a data list (i.e. the replication dimensions will not be dropped to create a data frame even if the resulting data list has only a single dimension).  To make use of the default replacement methods for lists, simply \code{\link{unclass}} the data list object as in \code{unclass(x)[...]}, \code{unclass(x)$i <- value}, and \code{unclass(x)[[i]] <- value}.
}
\seealso{
\code{\link{data.list}} for creating new data lists and \code{\link{as.data.frame.data.list}} for coercing data lists to data frames.
}
\examples{
data(fake.community)
fake.community

## array-like extraction
fake.community[1:3,,]
fake.community["arctic",c("2009","2008"),c(TRUE,TRUE,FALSE)]

## list-like extraction
fake.community["abundance"]
fake.community["body.size"]
fake.community["body.size",drop=FALSE]
fake.community[c("abundance","body.size")]
fake.community[1:3]

## assignment
fake.community$abundance  <- log1p(fake.community$abundance)
fake.community[[6]] <- NULL
fake.community$body.size <- fake.community$precipitation <- NULL
fake.community
}
