% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Closed.R
\name{markClosed}
\alias{markClosed}
\title{Fit closed population abundance models for ``traditional'' capture-mark-recapture data consisting of a single mark type}
\usage{
markClosed(Enc.Mat, covs = data.frame(), mod.p = ~1, parms = c("pbeta",
  "N"), nchains = 1, iter = 12000, adapt = 1000, bin = 50, thin = 1,
  burnin = 2000, taccept = 0.44, tuneadjust = 0.95, proppbeta = 0.1,
  propzp = 1, propsigmap = 1, npoints = 500, a = 25, mu0 = 0,
  sigma2_mu0 = 1.75, initial.values = NULL, printlog = FALSE, ...)
}
\arguments{
\item{Enc.Mat}{A matrix of observed encounter histories with rows corresponding to individuals and columns corresponding to sampling occasions. With a single mark type, encounter histories consist of only non-detections (0) and type 1 encounters (1).}

\item{covs}{A data frame of temporal covariates for detection probabilities (ignored unless \code{mms=NULL}). The number of rows in the data frame must equal the number of sampling occasions. Covariate names cannot be "time", "age", or "h"; these names are reserved for temporal, behavioral, and individual effects when specifying \code{mod.p} and \code{mod.phi}.}

\item{mod.p}{Model formula for detection probability. For example, \code{mod.p=~1} specifies no effects (i.e., intercept only), \code{mod.p~time} specifies temporal effects, \code{mod.p~c} specifies behavioral reponse (i.e., trap "happy" or "shy"), \code{mod.p~h} specifies individual heterogeneity, and \code{mod.p~time+c} specifies additive temporal and behavioral effects.}

\item{parms}{A character vector giving the names of the parameters and latent variables to monitor. Possible parameters are logit-scale detection probability parameters ("\code{pbeta}"), population abundance ("\code{N}"), logit-scale individual heterogeneity variance term ("\code{sigma2_zp}"), and logit-scale individual effects ("\code{zp}"). The log posterior density ("\code{logPosterior}") may also be monitored. Setting \code{parms="all"} monitors all possible parameters and latent variables.}

\item{nchains}{The number of parallel MCMC chains for the model.}

\item{iter}{The number of MCMC iterations.}

\item{adapt}{The number of iterations for proposal distribution adaptation. If \code{adapt = 0} then no adaptation occurs.}

\item{bin}{Bin length for calculating acceptance rates during adaptive phase (\code{0 < bin <= iter}).}

\item{thin}{Thinning interval for monitored parameters.}

\item{burnin}{Number of burn-in iterations (\code{0 <= burnin < iter}).}

\item{taccept}{Target acceptance rate during adaptive phase (\code{0 < taccept <= 1}). Acceptance rate is monitored every \code{bin} iterations. Default is \code{taccept = 0.44}.}

\item{tuneadjust}{Adjustment term during adaptive phase (\code{0 < tuneadjust <= 1}). If acceptance rate is less than \code{taccept}, then proposal term (\code{proppbeta}, \code{propzp}, or \code{propsigmap}) is multiplied by \code{tuneadjust}. If acceptance rate is greater than or equal to \code{taccept}, then proposal term is divided by \code{tuneadjust}. Default is \code{tuneadjust = 0.95}.}

\item{proppbeta}{Scaler or vector (of length k) specifying the initial standard deviation of the Normal(pbeta[j], proppbeta[j]) proposal distribution. If \code{proppbeta} is a scaler, then this value is used for all j = 1, ..., k. Default is \code{proppbeta = 0.1}.}

\item{propzp}{Scaler or vector (of length M) specifying the initial standard deviation of the Normal(zp[i], propzp[i]) proposal distribution. If \code{propzp} is a scaler, then this value is used for all i = 1, ..., M individuals. Default is \code{propzp = 1}.}

\item{propsigmap}{Scaler specifying the initial Gamma(shape = 1/\code{propsigmap}, scale = sigma_zp * \code{propsigmap}) proposal distribution for sigma_zp = sqrt(sigma2_zp). Default is \code{propsigmap=1}.}

\item{npoints}{Number of Gauss-Hermite quadrature points to use for numerical integration. Accuracy increases with number of points, but so does computation time.}

\item{a}{Scale parameter for [sigma_z] ~ half-Cauchy(a) prior for the individual hetegeneity term sigma_zp = sqrt(sigma2_zp). Default is ``uninformative'' \code{a = 25}.}

\item{mu0}{Scaler or vector (of length k) specifying mean of pbeta[j] ~ Normal(mu0[j], sigma2_mu0[j]) prior. If \code{mu0} is a scaler, then this value is used for all j = 1, ..., k. Default is \code{mu0 = 0}.}

\item{sigma2_mu0}{Scaler or vector (of length k) specifying variance of pbeta[j] ~ Normal(mu0[j], sigma2_mu0[j]) prior. If \code{sigma2_mu0} is a scaler, then this value is used for all j = 1, ..., k. Default is \code{sigma2_mu0 = 1.75}.}

\item{initial.values}{Optional list of \code{nchain} list(s) specifying initial values for "\code{pbeta}", "\code{zp}", "\code{sigma2_zp}", and "\code{N}". Default is \code{initial.values = NULL}, which causes initial values to be generated automatically.}

\item{printlog}{Logical indicating whether to print the progress of chains and any errors to a log file in the working directory. Ignored when \code{nchains=1}. Updates are printed to log file as 1\% increments of \code{iter} of each chain are completed. With >1 chains, setting \code{printlog=TRUE} is probably most useful for Windows users because progress and errors are automatically printed to the R console for "Unix-like" machines (i.e., Mac and Linux) when \code{printlog=FALSE}. Default is \code{printlog=FALSE}.}

\item{...}{Additional "\code{parameters}" arguments for specifying \code{mod.p}. See \code{\link[RMark]{make.design.data}}.}
}
\value{
A list containing the following:
\item{mcmc}{Markov chain Monte Carlo object of class \code{\link[coda]{mcmc.list}}.}
\item{mod.p}{Model formula for detection probability (as specified by \code{mod.p} above).}
\item{mod.delta}{Formula always \code{NULL}; only for internal use in \code{\link{multimodelClosed}}.}
\item{DM}{A list of design matrices for detection probability generated for model \code{mod.p}, where DM$p is the design matrix for initial capture probability (p) and DM$c is the design matrix for recapture probability (c).}
\item{initial.values}{A list containing the parameter and latent variable values at iteration \code{iter} for each chain. Values are provided for "\code{pbeta}", "\code{zp}", "\code{sigma2_zp}", and "\code{N}".}
\item{mms}{An object of class \code{multimarksetup}}
}
\description{
This function fits closed population abundance models for ``traditional'' capture-mark-recapture data consisting of a single mark type using Bayesian analysis methods. Markov chain Monte Carlo (MCMC) is used to draw samples from the joint posterior distribution.
}
\details{
The first time \code{markClosed} (or \code{\link{markCJS}}) is called, it will likely produce a firewall warning alerting users that R has requested the ability to accept incoming network connections. Incoming network connections are required to use parallel processing as implemented in \code{markClosed}. Note that setting \code{parms="all"} is required for any \code{markClosed} model output to be used in \code{\link{multimodelClosed}}.
}
\examples{
\dontshow{
test<-markClosed(Enc.Mat=simdataClosed(delta_1=1,delta_2=0)$Enc.Mat,iter=10,burnin=0,bin=5)}
\donttest{
# This example is excluded from testing to reduce package check time
# Example uses unrealistically low values for nchain, iter, and burnin

#Run single chain using the default model for simulated ``traditional'' data
data<-simdataClosed(delta_1=1,delta_2=0)$Enc.Mat
sim.dot<-markClosed(data)

#Posterior summary for monitored parameters
summary(sim.dot$mcmc)
plot(sim.dot$mcmc)}
}
\author{
Brett T. McClintock
}
\seealso{
\code{\link{multimodelClosed}}
}

