% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/value_correlation.R
\name{value_correlation}
\alias{value_correlation}
\title{Testing and quantifying how much ipsatization (profile centering) influence associations between value and a correlate}
\usage{
value_correlation(
  data,
  rv,
  cf,
  correlate,
  scale_by_rv = FALSE,
  standardize_correlate = FALSE,
  estimator = "ML",
  level = 0.95,
  sampling.weights = NULL,
  sesoi = 0
)
}
\arguments{
\item{data}{A data frame.}

\item{rv}{Character string or vector. Variable name(s) of the non-ipsatized value variable(s) (raw value score).}

\item{cf}{Character string. Variable name of the common factor that is used for ipsatizing raw value scores.}

\item{correlate}{Character string. Name of the variable to which associations with values are examined.}

\item{scale_by_rv}{Logical. Is standard deviation of the raw non-ipsatized value score used for scaling the common factor as well? (Default FALSE)}

\item{standardize_correlate}{Logical. Should the correlate be standardized? (Default FALSE)}

\item{estimator}{Character string. Estimator used in SEM (Default "ML").}

\item{level}{Numeric. The confidence level required for the result output (Default .95)}

\item{sampling.weights}{Character string. Name of sampling weights variable.}

\item{sesoi}{Numeric. Smallest effect size of interest. Used for equivalence testing differences in ipsatized and non-ipsatized value associations (Default 0).}
}
\value{
\item{parameter_estimates}{Parameter estimates from the structural equation model.}
\item{transformed_data}{Data frame with variables used in SEM (after scaling is applied).}
\item{results}{Summary of key results.}
}
\description{
Testing and quantifying how much ipsatization (profile centering) influence associations between value and a correlate
}
\examples{
\dontrun{
set.seed(342356)
d <- data.frame(
 rv1 = rnorm(50),
 rv2 = rnorm(50),
 rv3 = rnorm(50),
 rv4 = rnorm(50),
 x = rnorm(50)
)
d$cf<-rowMeans(d[,c("rv1","rv2","rv3","rv4")])
fit<-value_correlation(
 data = d, rv = c("rv1","rv2","rv3","rv4"), cf = "cf",
 correlate = "x",scale_by_rv = TRUE,
 standardize_correlate = TRUE,
 sesoi = 0.10
)
round(fit$variability_summary,3)
round(fit$association_summary,3)
}
}
