% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bmult_S3methods.R
\name{summary.bmult_bridge}
\alias{summary.bmult_bridge}
\title{summary method for class \code{bmult_bridge}}
\usage{
\method{summary}{bmult_bridge}(object, ...)
}
\arguments{
\item{object}{object of class \code{bmult_bridge} as returned from \code{\link{mult_bf_inequality}} or \code{\link{binom_bf_inequality}}}

\item{...}{additional arguments, currently ignored}
}
\value{
Invisibly returns a \code{list} which contains the log marginal likelihood and associated error terms.
}
\description{
Summarizes bridge sampling results and associated error measures
}
\examples{
# data
x <- c(3, 4, 10, 11)
n <- c(15, 12, 12, 12)
# priors
a <- c(1, 1, 1, 1)
b <- c(1, 1, 1, 1)
# informed hypothesis
factor_levels <- c('theta1', 'theta2', 'theta3', 'theta4')
Hr            <- c('theta1', '<',  'theta2', '<', 'theta3', '<', 'theta4')

## Multinomial Case
out_mult  <- mult_bf_inequality(x=x, Hr=Hr, a=a, factor_levels=factor_levels,
niter=1e3, seed=2020)
summary(out_mult)
}
