% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjust_uc_omc_sel.R
\name{adjust_uc_omc_sel}
\alias{adjust_uc_omc_sel}
\title{Adust for uncontrolled confounding, outcome misclassification, and selection
bias.}
\usage{
adjust_uc_omc_sel(
  data,
  exposure,
  outcome,
  confounders = NULL,
  u_model_coefs,
  y_model_coefs,
  s_model_coefs,
  level = 0.95
)
}
\arguments{
\item{data}{Dataframe for analysis.}

\item{exposure}{String name of the exposure variable.}

\item{outcome}{String name of the outcome variable.}

\item{confounders}{String name(s) of the confounder(s).
A maximum of three confounders is allowed.}

\item{u_model_coefs}{The regression coefficients corresponding to the model:
\ifelse{html}{\out{logit(P(U=1)) = &alpha;<sub>0</sub> + &alpha;<sub>1</sub>X + &alpha;<sub>2</sub>Y, }}{\eqn{logit(P(U=1)) = \alpha_0 + \alpha_1 X + \alpha_2 Y, }}
where \emph{U} is the binary unmeasured confounder, \emph{X} is the
binary exposure, and \emph{Y} is the binary true outcome.
The number of parameters therefore equals 3.}

\item{y_model_coefs}{The regression coefficients corresponding to the model:
\ifelse{html}{\out{logit(P(Y=1)) = &delta;<sub>0</sub> + &delta;<sub>1</sub>X + &delta;<sub>2</sub>Y* + &delta;<sub>2+j</sub>C<sub>j</sub>, }}{\eqn{logit(P(Y=1)) = \delta_0 + \delta_1 X + \delta_2 Y^* + \delta_{2+j} C_j, }}
where \emph{Y} represents binary true outcome, \emph{X} is the
binary exposure, \emph{Y}* is the binary misclassified outcome, \emph{C}
represents the vector of measured confounders (if any),
and \emph{j} corresponds to the number of measured
confounders. The number of parameters therefore equals 3 + \emph{j}.}

\item{s_model_coefs}{The regression coefficients corresponding to the model:
\ifelse{html}{\out{logit(P(S=1)) = &beta;<sub>0</sub> + &beta;<sub>1</sub>X + &beta;<sub>2</sub>Y* + &beta;<sub>2+j</sub>C<sub>2+j</sub>, }}{\eqn{logit(P(S=1)) = \beta_0 + \beta_1 X + \beta_2 Y^* + \beta_{2+j} C_j, }}
where \emph{S} represents binary selection, \emph{X} is the binary exposure,
\emph{Y*} is the binary misclassified outcome, \emph{C} represents
the vector of measured confounders (if any), and \emph{j} corresponds
to the number of measured confounders.
The number of parameters therefore equals 3 + \emph{j}.}

\item{level}{Value from 0-1 representing the full range of the confidence
interval. Default is 0.95.}
}
\value{
A list where the first item is the odds ratio estimate of the
effect of the exposure on the outcome and the second item is the
confidence interval as the vector: (lower bound, upper bound).
}
\description{
\code{adjust_uc_omc_sel} returns the exposure-outcome odds ratio and
confidence interval, adjusted for uncontrolled confounding, outcome
misclassificaiton, and selection bias.
}
\details{
This function uses two separate logistic regression models to predict the
uncontrolled confounder (\emph{U}) and outcome (\emph{Y}).
If a single bias model for jointly modeling \emph{Y} and \emph{U} is
desired use \code{adjust_multinom_uc_omc_sel}.

Values for the regression coefficients can be applied as
fixed values or as single draws from a probability
distribution (ex: \code{rnorm(1, mean = 2, sd = 1)}). The latter has
the advantage of allowing the researcher to capture the uncertainty
in the bias parameter estimates. To incorporate this uncertainty in the
estimate and confidence interval, this function should be run in loop across
bootstrap samples of the dataframe for analysis. The estimate and
confidence interval would then be obtained from the median and quantiles
of the distribution of odds ratio estimates.
}
\examples{
adjust_uc_omc_sel(
  df_uc_omc_sel,
  exposure = "X",
  outcome = "Ystar",
  confounders = c("C1", "C2", "C3"),
  u_model_coefs = c(-0.32, 0.59, 0.69),
  y_model_coefs = c(-2.85, 0.71, 1.63, 0.40, -0.85, 0.22),
  s_model_coefs = c(0.00, 0.74, 0.19, 0.02, -0.06, 0.02)
)

}
