% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Pn_logtDensity.R
\docType{class}
\name{Pn_logtDensity-class}
\alias{Pn_logtDensity-class}
\alias{Pn_logtDensity}
\title{An S4 class to represent the function \eqn{(\prod_{i=1}^n x_i^{-1})\frac{\Gamma\left[(\nu+n)/2\right]}{\Gamma(\nu/2)\nu^{n/2}\pi^{n/2}\left|{\Sigma}\right|^{1/2}}\left[1+\frac{1}{\nu}({\log(\vec{x})}-{\vec{\delta}})^{T}{\Sigma}^{-1}({\log(\vec{x})}-{\vec{\delta}})\right]^{-(\nu+n)/2}} on \eqn{[0,\infty)^n}}
\description{
Implementation of the function
\deqn{f \colon [0,\infty)^n \to (0,\infty),\, \vec{x} \mapsto f(\vec{x}) = (\prod_{i=1}^n x_i^{-1})\frac{\Gamma\left[(\nu+n)/2\right]}{\Gamma(\nu/2)\nu^{n/2}\pi^{n/2}\left|{\Sigma}\right|^{1/2}}\left[1+\frac{1}{\nu}({\log(\vec{x})}-{\vec{\delta}})^{T}{\Sigma}^{-1}({\log(\vec{x})}-{\vec{\delta}})\right]^{-(\nu+n)/2},}
where \eqn{n \in \{1,2,3,\ldots\}} is the dimension of the integration domain \eqn{[0,\infty)^n = \times_{i=1}^n [0,\infty)}.
In this case the integral is know to be
\deqn{\int_{[0,\infty)^n} f(\vec{x}) d\vec{x} = 1.}
}
\details{
The instance needs to be created with four parameters representing the dimension \eqn{n}, the location vector \eqn{\vec{\delta}}, the variance-covariance matrix \eqn{\Sigma} which needs to be symmetric positive definite and the degrees of freedom parameter \eqn{\nu}.
}
\section{Slots}{

\describe{
\item{\code{dim}}{An integer that captures the dimension}

\item{\code{delta}}{A vector of size dim with real entries.}

\item{\code{sigma}}{A matrix of size dim x dim that is symmetric positive definite.}

\item{\code{df}}{A positive numerical value representing the degrees of freedom.}
}}

\examples{
n <- as.integer(3)
f <- new("Pn_logtDensity",dim=n,delta=rep(0,n),sigma=diag(n),df=3)
}
\author{
Klaus Herrmann
}
