% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rename.R
\name{rename_values_base}
\alias{rename_values_base}
\title{Replace/rename values in a vector}
\usage{
rename_values_base(x, ..., default_value = x, warn_missing = TRUE,
  warn_duplicated = TRUE)
}
\arguments{
\item{x}{Vector of values to replace}

\item{...}{Key/value pairs in the form \code{oldvalue="newvalue"}}

\item{default_value}{A vector of values to use as the default should the value not
be found in \code{...}}

\item{warn_missing}{Print a message if any old names are not actually present in x}

\item{warn_duplicated}{Print a message if any name appears more than once in x 
after the operation.}
}
\value{
A vector with values replaced
}
\description{
This function replaces character values with new character values, which
is useful when performing rename operations when values are held in character vectors.
}
\keyword{internal}
