% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_ontology_code.R
\name{map_ontology_code}
\alias{map_ontology_code}
\title{Map tumor types across ontologies}
\source{
The mappings here provided are based on the file \url{https://github.com/cBioPortal/oncotree/blob/master/scripts/ontology_to_ontology_mapping_tool/ontology_mappings.txt}.
}
\usage{
map_ontology_code(code, from, to, collapse = NULL)
}
\arguments{
\item{code}{A character vector with identifier codes of the \code{from} ontology that are meant to be mapped to the \code{to} ontology.}

\item{from}{The source ontology. One of: \code{'oncotree_code'}, \code{'nci_code'}, \code{'umls_code'}, \code{'icdo_topography_code'}, \code{'icdo_morphology_code'}, and \code{'hemeonc_code'}.}

\item{to}{The target ontology. One of: \code{'oncotree_code'}, \code{'nci_code'}, \code{'umls_code'}, \code{'icdo_topography_code'}, \code{'icdo_morphology_code'}, and \code{'hemeonc_code'}.}

\item{collapse}{A function that expects one argument, it will be the character vector of codes in the \code{to} variable, that are to be "collapsed". When the mapping is one-to-many, passing a collapsing function will allow you to make the mapping one-to-one. See examples.}
}
\value{
A \link[tibble:tibble-package]{tibble} of two variables: first column is
corresponds to the \code{from} variable and the second is the \code{to} variable.
}
\description{
This function maps codes (identifiers) across tumor classification systems.
Use the arguments \code{from} and \code{to} to choose the source and target ontologies.
Available options are: \code{'oncotree_code'}, \code{'nci_code'}, \code{'umls_code'},
\code{'icdo_topography_code'}, \code{'icdo_morphology_code'}, and \code{'hemeonc_code'}.

Note that you can also use the functions \code{\link[=oncotree_to_nci]{oncotree_to_nci()}},
\code{\link[=nci_to_oncotree]{nci_to_oncotree()}}, \code{\link[=oncotree_to_umls]{oncotree_to_umls()}} and \code{\link[=umls_to_oncotree]{umls_to_oncotree()}} to map
between OncoTree and NCIt systems. The difference is that these functions use
the OncoTree API, and the output can be made to depend on older versions of
OncoTree. \code{map_ontology_code()} relies on a static file provided by the
OncoTree team that is not as up to date as the data provided by the web API.
Nevetheless, the scope of the mappings provided by \code{map_ontology_code()} is
broader. The file used by \code{map_ontology_code()} can be directly imported into
R using the function \code{read_ontology_mappings()}.
}
\examples{
\dontrun{
# Omit the `code` argument to get all possible mappings. Note that
# one-to-many mappings will generate more than one row per `from` code.
map_ontology_code(from = 'oncotree_code', to = 'nci_code')

# Simple example
map_ontology_code('MMB', from = 'oncotree_code', to = 'nci_code')

# Some mappings are one-to-many, e.g. "SRCCR", which means repeated rows for
# the same input code.
map_ontology_code('SRCCR', from = 'oncotree_code', to = 'nci_code')

# Using the `collapse` argument to "collapse" one-to-many mappings makes sure
# that the output has as many rows as the `from` vector.
map_ontology_code('SRCCR',
                  from = 'oncotree_code',
                  to = 'nci_code',
                  collapse = toString)

map_ontology_code('SRCCR',
                  from = 'oncotree_code',
                  to = 'nci_code',
                  collapse = list)

map_ontology_code(
  'SRCCR',
  from = 'oncotree_code',
  to = 'nci_code',
  collapse = \(x) paste(x, collapse = ' ')
)

# `map_ontology_code()` is vectorized over `code`
map_ontology_code(
  c('AASTR', 'MDEP'),
  from = 'oncotree_code',
  to = 'nci_code'
  )

# Map from ICDO topography to ICDO morphology codes
map_ontology_code(
  'C72.9',
  from = 'icdo_topography_code',
  to = 'icdo_morphology_code'
  )
}
}
\seealso{
\code{\link[=oncotree_to_nci]{oncotree_to_nci()}}, \code{\link[=nci_to_oncotree]{nci_to_oncotree()}}, \code{\link[=oncotree_to_umls]{oncotree_to_umls()}} and \code{\link[=umls_to_oncotree]{umls_to_oncotree()}}.
}
