
as.matrix.massvectorlist<-function(x)
  {
    ##t Matrices
    ##- Turns the massvectorlist into a matrix. On each massvectorlist the \code{summary} method is called.
    ##- The result of \code{summary} are combined into a matrix.
    ##+ x : massvectorlist
    ##v matrix : matrix with columns :"lengthmv","mass.Min.",...,"area.Max." 
    ##sa as.data.frame.massvectorlist,\link[base]{as.matrix},link[base]{as.data.frame}
    ##e data(mvl)
    ##e tmp<-as.matrix(mvl)
    ##e print(colnames(mvl))
    ##e plot(tmp[,"lengthmv"],tmp[,"mass.Min."])
    print("test")
    mvl<-x
    rm(x)
    res <- lapply(mvl,summary)
    res <- t(sapply(res,unlist))
    
    res
  }

as.data.frame.massvectorlist<-function(x,...)
  {
    
    ##t Data Frames
    ##- Turns the mlist object into a data.frame
    ##d These functions create a data frame, tightly coupled
    ##d collections of variables which share many of the properties of
    ##d matrices and of lists, used as the fundamental data structure by
    ##d most of R's modeling software.
    ##+ x : object of class massvectorlist
    ##+ ... : further arguments
    ##sa as.matrix.massvectorlist, as.matrix
    ##e data(mvl)
    ##e tmp <- as.data.frame(mvl)
    ##e names(mvl)
    ##e plot(tmp$lengthmv,tmp$mass.Min.)

    
    res<-NULL
    tmp<-as.matrix(x)
    ntmp<-names(x)
    res<-data.frame(info=as.character(ntmp),tmp)
    res
  }











#as.data.frame.caliblist<-function(x,row.names=NULL,optional=FALSE)
#  {
    ##t Data Frames
    ##- Turns the caliblist into a data.frame
    ##d These functions create a data frame, tightly coupled
    ##d collections of variables which share many of the properties of
    ##d matrices and of lists, used as the fundamental data structure by
    ##d most of R's modeling software.
    ##+ x : object of class caliblist
    ##+ row.names : \code{NULL} or a character vector giving the row names for the data frame.  Missing values are not allowed.
    ##+ optional: logical. If \code{TRUE}, setting row names is optional. 
    ##sa as.matrix.caliblist, \link[base]{as.data.frame}, calibrelist, calibintlist
    ##e data(mvl)
    ##e mvl<-mvl[1:100]
    ##e data(cal)
    ##e test<-getintcalib(mvl,cal,error=500)
    ##e tmp<-as.data.frame(test)
    ##e names(tmp)
#      dat<-NULL
#      dat<-sapply(x,as.vector)
#      dat <- data.frame(info=names(x),t(dat))
#      dat
#  }

#as.matrix.caliblist<-function(x)
#{
  ##t Matrices
  ##- Turns the caliblist into a matrix
  ##+ x : caliblist
  ##v matrix : matrix with masses and intensities.
  ##sa as.data.frame.caliblist
  ##e data(mvl)
  ##e mvl<-mvl[1:100]
  ##e data(cal)
  ##e test<-getintcalib(mvl,cal,error=500)
  ##e tmp<-as.matrix(test)
  ##e colnames(tmp)
  ##e dim(tmp)
#  dat<-t(sapply(x,as.vector))
#  dat
#}


summary.caliblist<-function(object,...)
  {
    ##t Massvector Summaries
    ##- Generates a summary: min , max etc for the data.frame generated by as.data.frame.massvectorlist
    ##+ object : caliblist
    ##sa as.data.frame.caliblist ,\link[base]{summary} 
    ##e data(mvl)
    ##e mvl<-mvl[1:100]
    ##e data(cal)
    ##e test <- getintcalib(mvl,cal,error=500)
    ##e summary(test)
    ##e summary(test)

    res<-list(info=info(object))
    dat<-as.matrix(object)
    colnames(dat)<-names(as.vector(object[[1]]))
    rownames(dat)<-NULL
    res<-c(res,list(summary=summary(dat)))
    res
  }

