% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nmxml.R
\name{read_nmext}
\alias{read_nmext}
\title{Extract estimates from NONMEM ext file}
\usage{
read_nmext(run, project = getwd(), file = paste0(run, ".ext"),
  path = NULL)
}
\arguments{
\item{run}{a run number or run identifier}

\item{project}{the NONMEM project directory}

\item{file}{the \code{ext} file name}

\item{path}{full path and file name for \code{ext} file}
}
\value{
A list with param, omega, and sigma in a format
ready to be used to update a model object.
}
\description{
Extract estimates from NONMEM ext file
}
\examples{
project <- system.file("nonmem", package = "mrgsolve")

est <- read_nmext(1005, project = project)

est$param

est$omega

est$sigma

}
