% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/events.R
\docType{methods}
\name{ev}
\alias{ev}
\alias{ev,mrgmod-method}
\alias{ev,missing-method}
\alias{ev,ev-method}
\title{Event objects for simulating PK and other interventions}
\usage{
ev(x, ...)

\S4method{ev}{mrgmod}(x, object = NULL, ...)

\S4method{ev}{missing}(time = 0, evid = 1, ID = numeric(0), cmt = 1,
  replicate = TRUE, until = NULL, realize_addl = FALSE, ...)

\S4method{ev}{ev}(x, realize_addl = FALSE, ...)
}
\arguments{
\item{x}{a model object}

\item{...}{passed on}

\item{object}{passed to show}

\item{time}{event time}

\item{evid}{event ID}

\item{ID}{subject ID}

\item{cmt}{compartment}

\item{replicate}{logical; if \code{TRUE}, events will be replicated for 
each individual in \code{ID}}

\item{until}{the expected maximum \bold{observation} time for this regimen}

\item{realize_addl}{if \code{FALSE} (default), no change to \code{addl} 
doses.  If \code{TRUE}, \code{addl} doses are made explicit with 
\code{\link{realize_addl}}}
}
\value{
events object
}
\description{
An event object contains one or more dosing records that 
makes up a dosing regimen.  The event object may include 
an ID column, but it usually doesn't.  Event objects have 
operators and other functions that can take simple or elementary 
event sequences and combine them in potentially more complicated
ways.
}
\details{
\itemize{
\item Required input for creating events objects include 
\code{time} and \code{cmt}
\item If not supplied, \code{evid} is assumed to be 1.
\item If not supplied, \code{cmt}  is assumed to be 1.
\item If not supplied, \code{time} is assumed to be 0.
\item \code{ID} may be specified as a vector.
\item If replicate is \code{TRUE} (default), thenthe events 
regimen is replicated for each \code{ID}; otherwise, the number of
event rows must match the number of \code{ID}s entered
}
}
\examples{
mod <- mrgsolve:::house()
mod <- mod \%>\% ev(amt=1000, time=0, cmt=1)
events(mod)

loading <- ev(time=0, cmt=1, amt=1000)
maint <- ev(time=12, cmt=1, amt=500, ii=12, addl=10)
loading + maint


ev(ID=1:10, cmt=1, time=0, amt=100)


}
\seealso{
\code{\link{ev_rep}}, \code{\link{ev_days}}, 
\code{\link{ev_repeat}}, \code{\link{ev_assign}},
\code{\link{ev_seq}}, \code{\link{mutate.ev}},
\code{\link{as.ev}}, \code{\link{ev_methods}}
}
