% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrfi_class.R
\name{mrfi}
\alias{mrfi}
\title{Creation of \code{\link[=mrfi-class]{mrfi}} objects.}
\usage{
mrfi(max_norm = 1, norm_type = "1", positions = NULL)
}
\arguments{
\item{max_norm}{a \code{numeric} value. All points with norm \eqn{\le} \code{max_dist}
are included.}

\item{norm_type}{a \code{character} indicating the norm type used. Possible values
are "m", "1", "2", etc. See \code{\link[=norm]{norm}} for details.}

\item{positions}{a \code{list} of \code{numeric} vectors of length 2. Each vector
corresponds to a relative position included.}
}
\value{
A \code{\link[=mrfi-class]{mrfi}} object.
}
\description{
\code{mrfi()} creates an object of class \code{mrfi} based on a distance
rule and optionally a list of relative positions. The argument \code{max_norm} and
\code{norm_type} can be used to automatically include all positions within a
"range" defined by the norm type chosen and distance using that norm.

A list of relative positions may also be included to specify sparse
interaction structures, for example.
}
\note{
If a position in \code{positions} is already included due to the
\code{max_norm} and \code{norm_type} specification, the second ocurrence is ignored.
The same is valid for repeated or opposite positions in \code{positions}.
}
\examples{
mrfi(1)
mrfi(2)
mrfi(2, norm_type = "m")
mrfi(1, positions = list(c(4,4), c(-4,4)))

#Repeated positions are handled automatically
mrfi(1, positions = list(c(1,0), c(2,0)))

}
\author{
Victor Freguglia
}
