% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_gaz_search.R
\name{gaz_search}
\alias{gaz_search}
\alias{gaz_search.character}
\alias{gaz_search.numeric}
\alias{gaz_search.sfg}
\alias{gaz_search.sf}
\alias{gaz_search.sfc}
\title{Search in the Marine Regions Gazetteer by names, MRGID or reverse geocode with a pair of
WGS84 coordinates x and y}
\usage{
gaz_search(x, ...)

\method{gaz_search}{character}(x, ...)

\method{gaz_search}{numeric}(x, ..., y = NULL)

\method{gaz_search}{sfg}(x, ...)

\method{gaz_search}{sf}(x, ...)

\method{gaz_search}{sfc}(x, ...)
}
\arguments{
\item{x}{object to perform the search with. Can be:
\itemize{
\item (character) Free text search
\item (integer) A valid Marine Regions Gazetteer Identifier (\link{MRGID})
\item (double) Longitude in WGS84
\item Aditionally, you can pass objects of class \link[sf:sf]{sf::sf} or \link[sf:sfc]{sf::sfc} with geometry
of class \code{POINT}
}}

\item{...}{
  Arguments passed on to \code{\link[=gaz_rest_record_by_mrgid]{gaz_rest_record_by_mrgid}}, \code{\link[=gaz_rest_records_by_name]{gaz_rest_records_by_name}}, \code{\link[=gaz_rest_records_by_names]{gaz_rest_records_by_names}}, \code{\link[=gaz_rest_records_by_lat_long]{gaz_rest_records_by_lat_long}}
  \describe{
    \item{\code{with_geometry}}{(logical) Add geometry to the result data frame? Default = FALSE}
    \item{\code{rdf}}{(logical) Return an object of class \link[rdflib:rdf]{rdflib::rdf}?}
    \item{\code{typeid}}{(numeric) Restrict to one or more placetypeIDs. Retrieve a list of placetypeIDs with \code{\link[=gaz_rest_types]{gaz_rest_types()}}}
    \item{\code{language}}{(character) Restrict to one language. Provide as a 2 digits ISO-639. See \link[ISOcodes:ISO_639]{ISOcodes::ISO_639_2}.}
    \item{\code{like}}{(logical) Add a '\%'-sign before and after the name? (SQL LIKE function). Default = TRUE}
    \item{\code{fuzzy}}{(logical) Use Levenshtein query to find nearest matches? Default = TRUE}
  }}

\item{y}{(double) Latitude in WGS84 (Optional)}
}
\value{
A data frame with Gazetteer entries
}
\description{
Search in the Marine Regions Gazetteer by names, MRGID or reverse geocode with a pair of
WGS84 coordinates x and y
}
\examples{
\donttest{

# Look-up a name in the Gazetteer
gaz_search("North Sea")

# Get the entries of two known MRGID including their geometry
gaz_search(c(14, 17), with_geometry = TRUE)

# Maybe the name is in another language...
gaz_search("Noordzee", language = "nl")

# Get all the records intersecting with the longitude 51.21551 and latitude 2.927
# restricting to some placetypes
gaz_search(x = 2.927, y = 51.21551, typeid = c(255, 259))
}
}
