% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcds_tools.R
\name{MCDS.exe}
\alias{MCDS.exe}
\alias{MCDS}
\alias{mcds_dot_exe}
\title{Run MCDS.exe as a backend for mrds}
\description{
Rather than use the R-based detection function fitting algorithms provided in 
`mrds`, one can also use the algorithm used by Distance for Windows, implemented
in the binary file `MCDS.exe`.  Note that with changes in R-based optimizer introduced 
in `mrds` version 3.0.0 this is unlikely to result in better estimates.  
The option remains available, although it may be deprecated in a future release.
To make use of this facility, one must first download the `MCDS.exe` binary, as
laid out below under `Obtaining MCDS.exe`.  Once the binary is installed, calls
to `ddf` will, by default, result in using the model being fit using both `MCDS.exe`
and the R-based algorithm, and the one with lower negative log-likelihood being selected.
In almost all cases, both algorithms produce the same results, but we have found edge
where one or other fails to find the likelihood maximum and hence trying both is useful.
}
\details{
There may also be cases where the `MCDS.exe` algorithm is faster than the R-based one.
Under this circumstance, you can choose to run only the `MCDS.exe` algorithm via by setting
the `ddf` argument \code{control=list(optimizer='MCDS')}.  For completeness, one can also
choose to use only the R-based algorithm by setting \code{control=list(optimizer='R')}.

For more information and examples comparing the R-based and `MCDS.exe` algorithms,
see our examples pages at https://examples.distancesampling.org/

If you are running a non-Windows operating system, you can follow the
instructions below to have `MCDS.exe` run using `wine`.
}
\section{Obtaining MCDS.exe}{

The following code can be used to download `MCDS.exe` from the distance 
sampling website:
\code{download.file("http://distancesampling.org/R/MCDS.exe", paste0(system.file(package="mrds"),"/MCDS.exe"), mode = "wb")}
The MCDS binary will be installed to the main directory of your your local R 
mrds library. Alternatively, you can copy the `MCDS.exe` from your local 
Distance for Windows installation if you prefer. The location of your local 
mrds library main directory can be found by running the following in R:
\code{system.file("MCDS.exe", package="mrds")}.
}

\section{Running MCDS.exe on non-Windows platforms}{

This has been tentatively tested on a mac but should currently be 
considered largely experimental.

One can still use MCDS.exe even if you are running a mac computer. To
do this one will need to install `wine` a Windows emulator. It is important
to use a version of `wine` which can run 32-bit programs.

The package will attempt to work out which `wine` binary to use (and detect
if it is installed), but this doesn't always work. In this case, the
location of the `wine` binary can be specified in the `control` `list`
provided to `ddf` using the `winebin` element or supply the `winebin` 
argument to the `ds` function. For example, if `wine` is installed at 
`/usr/bin/local/wine` you can set `control$winebin` to that
location to use that binary.

On macOS, this can be achieved using the `homebrew` package management
system and installing the `wine-crossover` package. You may need to change
the \code{control$winebin} to be `wine`, `wine64` or `wine32on64`, 
depending on your system's setup. This package tries to work out what to 
do, but likely doesn't handle all corner cases. Currently this is untested 
on Mac M1 systems.
}

\section{Stopping using MCDS.exe}{

Once this feature is enabled, using `ddf` will by default run both
its built-in R optimizer and `MCDS.exe`. To disable this behaviour, specify which 
you wish to use with via the \code{optimizer=} option described above.  Alternatively,
if you wish to permanently stop using MCDS.exe, remove
the `MCDS.exe` binary file. You can find which folder it is in by running the following in R:
\code{system.file("MCDS.exe", package="mrds")}.
}

\author{
David L Miller and Jonah McArthur
}
