% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrds-package.R
\docType{data}
\name{book.tee.data}
\alias{book.tee.data}
\title{Golf tee data used in chapter 6 of Advanced Distance Sampling examples}
\format{
A list of 4 dataframes, with the list elements named: book.tee.dataframe,
  book.tee.region, book.tee.samples and book.tee.obs. 
  
  \strong{book.tee.dataframe} is the distance sampling data 
  dataframe. Used in the call to fit the detection function in \code{ddf}.
  Contains the following columns:
  
  \describe{
  \item{object}{numeric object id}\item{observer}{factor representing observer
  1 or 2}\item{detected}{numeric 1 if the animal was detected 0 otherwise}
  \item{distance}{numeric value for the distance the animal was detected}
  \item{size}{numeric value for the group size}\item{sex}{numeric value for
  sex of animal}\item{exposure}{numeric value for exposure level 0 or 1}}
  
  \strong{book.tee.region}: is the region table dataframe. Used to
  supply the strata areas to the \code{dht} function. Contains the following
  columns:
  
  \describe{
  \item{Region.Label}{factor giving the strata labels}
  \item{Area}{numeric value giving the strata areas}}
  
  \strong{book.tee.samples} is the samples table dataframe to match 
  the transect ids to the region ids and supply the effort. Used in the 
  \code{dht} function. Contains the following columns:
  
  \describe{
  \item{Sample.Label}{numeric giving the sample / transect labels}
  \item{Region.Label}{factor giving the strata labels}
  \item{Effort}{numeric value giving the sample / transect lengths}}
  
  \strong{book.tee.obs} is the observations table dataframe to match
  the object ids in the distance data to the transect labels. Used in the 
  \code{dht} function. Contains the following columns:

  \describe{
  \item{object}{numeric value object id}
  \item{Region.Label}{factor giving the strata labels}
  \item{Sample.Label}{numeric giving the sample / transect labels}}
}
\description{
Double platform data collected in a line transect survey of golf tees by 2
observers at St. Andrews. Field sex was actually colour of the golf tee: 0 -
green; 1 - yellow. Exposure was either low (0) or high(1) depending on
height of tee above the ground. size was the number of tees in an observed
cluster.
}
\keyword{datasets}
