% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/keyfct.tpn.R
\name{keyfct.tpn}
\alias{keyfct.tpn}
\alias{two-part-normal}
\title{Two-part normal key function}
\usage{
keyfct.tpn(distance, ddfobj)
}
\arguments{
\item{distance}{perpendicular distance vector}

\item{ddfobj}{meta object containing parameters, design matrices etc}
}
\value{
a vector of probabilities that the observation were detected given
they were at the specified distance and assuming that g(mu)=1
}
\description{
The two-part normal detection function of Becker and Christ (2015). Either
side of an estimated apex in the distance histogram has a half-normal
distribution, with differing scale parameters. Covariates may be included
but affect both sides of the function.
}
\details{
Two-part normal models have 2 important parameters:
\itemize{
 \item The apex, which estimates the peak in the detection function (where
 g(x)=1). The log apex is reported in \code{summary} results, so taking the
 exponential of this value should give the peak in the plotted function (see
 examples).
 \item The parameter that controls the difference between the sides
 \code{.dummy_apex_side}, which is automatically added to the formula for a
 two-part normal model. One can add interactions with this variable as
 normal, but don't need to add the main effect as it will be automatically
 added.
}
}
\references{
Becker, E. F., & Christ, A. M. (2015). A Unimodal Model for Double Observer
Distance Sampling Surveys. PLOS ONE, 10(8), e0136403.
\doi{10.1371/journal.pone.0136403}
}
\author{
Earl F Becker, David L Miller
}
