NCovered.io.fi <- function(par=NULL,model,group=TRUE,...){
  # see docs in NCovered
  #
  # Computes abundance in covered region for io.fi model object
  #
  #  par   - parameter values (used when computing derivatives wrt 
  #          parameter uncertainty)
  #  model - ddf model object
  #  group - if TRUE computes group abundance and if FALSE individual abundance
  #
  # return: abundance estimate
  # Functions Used: predict (predict.io.fi), compute.Nht

  # set pars if we are differentiating
  # then extract fitted values
  if(!is.null(par)){
    model$mr$coefficients <- par
    fitted <- predict(model,integrate=TRUE)$fitted
  }else{
    fitted <- model$fitted
  }

  # if the data has group size then use that
  if(!group){
    size <- model$data$size[model$data$observer==1&model$data$object %in%
                            as.numeric(names(model$fitted))]
    Nhat <- sum(compute.Nht(fitted,FALSE,size))
  }else{
    Nhat <- sum(compute.Nht(fitted,TRUE,size=NULL))
  }

  return(Nhat)
}
