% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrbin.R
\name{mrheatmap}
\alias{mrheatmap}
\title{A function for plotting heatmaps.}
\usage{
mrheatmap(
  results,
  binlist = NULL,
  samplelist = NULL,
  annotate = FALSE,
  cexRow = 0.7,
  cexCol = 0.8,
  margins = c(4, 6),
  Colv = NA,
  Rowv = NULL,
  closeDevice = TRUE,
  ...
)
}
\arguments{
\item{results}{Either an mrbin object or a numeric matrix containing sample names as rownames and feature names as columns names.}

\item{binlist}{A vector containing bin names as they are generated by mrbin (colnames). If provided, only these columns will be shown.}

\item{samplelist}{A vector containing sample names (rownames). If provided, only these rows will be shown.}

\item{annotate}{Should peak annotations be shown? This requires annotation data in the mrbin object.}

\item{cexRow}{Font size for row labels}

\item{cexCol}{Font size for column labels}

\item{margins}{Determines the plot margins.}

\item{Colv}{Determines if and how the column dendrogram should be computed and reordered. Default: NA (dendrogram will not be used)}

\item{Rowv}{Determines if and how the row dendrogram should be computed and reordered. Default: NULL (dendrogram will be used)}

\item{closeDevice}{Should previous plots be closed prior to plotting?}

\item{...}{Additional graphical parameters that will be passed to the stats function heatmap}
}
\value{
{None}
}
\description{
This function plots heatmaps based on rank order, using heatmap from the stats package
}
\examples{
resetEnv()
# First create NMR bin data, then plot some differential bins.
results<-mrbin(silent=TRUE,setDefault=TRUE,parameters=list(verbose=FALSE,
                dimension="1D",binwidth1D=0.01,PCA="No",showSpectrumPreview="No",
                signal_to_noise1D=25,noiseThreshold=0.75,useAsNames="Spectrum titles",
                NMRfolders=c(
                system.file("extdata/1/10/pdata/10",package="mrbin"),
                system.file("extdata/2/10/pdata/10",package="mrbin"),
                system.file("extdata/3/10/pdata/10",package="mrbin"))
                ))
metadata<-c(0,0,1)
#Find significant signals
pvalues<-rep(NA,ncol(results$bins))
names(pvalues)<-colnames(results$bins)
for(i in 1:ncol(results$bins)){
	model<-stats::lm(intensity~treatment, 
     data=data.frame(intensity=results$bins[,i],treatment=metadata))
	pvalues[i]<-stats::anova(model)$"Pr(>F)"[1]
}
significantBins<-names(sort(pvalues)[1:30]) 
metaboliteIdentities=matrix(c(1.346,1.324,21,23,
                              3.052,3.043,30.5,33.5,
                              5.7,6.0,0,150),
                   ncol=4,byrow=TRUE)
#Annotate the dataset with signal identities
rownames(metaboliteIdentities)=c("Lactate","Creatinine","Urea")
results<-annotatemrbin(results,metaboliteIdentities=metaboliteIdentities)
mrheatmap(results=results,
    binlist=significantBins,annotate=TRUE,
    main="Significant signals")
}
