% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrbin.R
\name{plotPCA}
\alias{plotPCA}
\title{A function for plotting PCA plots.}
\usage{
plotPCA(
  mrbinResults,
  defineGroups = TRUE,
  loadings = FALSE,
  legendPosition = "bottomleft",
  annotate = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{mrbinResults}{An mrbin object}

\item{defineGroups}{Should groups be colored differently?}

\item{loadings}{Should loadings be plotted instead of scores?}

\item{legendPosition}{Where should the legend be plotted, Defaults to "left", other options include "top", "topright", etc.}

\item{annotate}{Should loadings be annotated with metabolite identities, if available in $metadata?}

\item{verbose}{Should a summary be displayed?}
}
\value{
An invisible prcomp result object
}
\description{
This function performs PCA, then plots PC1 and PC2.
}
\examples{
mrbinResults<-mrbin(silent=TRUE,setDefault=FALSE,parameters=list(dimension="2D",
    binRegion=c(8,1,15,140),binwidth2D=0.1,binheight=4,solventRegion=c(5.5,4.2),
    PQNScaling="No",noiseRemoval="Yes",trimZeros="Yes",tryParallel=TRUE,
    fixNegatives="No",logTrafo="No",PCA="No",signal_to_noise2D=10,
    NMRfolders=c(system.file("extdata/1/12/pdata/10",package="mrbin"),
                 system.file("extdata/2/12/pdata/10",package="mrbin"))))
plotPCA(mrbinResults)
}
