% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrbin.R
\name{predictWrapper}
\alias{predictWrapper}
\title{A function returning predicted values for use with the fia function.}
\usage{
predictWrapper(
  model,
  dataSet,
  functionNamePredict = "predict",
  firstLevel = 1,
  parameterNameObject = "object",
  parameterNameData = "x",
  dataFrameFlag = FALSE,
  ...
)
}
\arguments{
\item{model}{A predictive model. Make sure to have loaded all required packages before starting this function}

\item{dataSet}{A matrix or dataframe containing data, depending on what your predict function requires. Columns=features, rows=samples}

\item{functionNamePredict}{The name of the prediction function. This only needs to be changed if the prediction function is not called predict}

\item{firstLevel}{Numeric value of first level or group. Usually 1 but for glm such as in the example this needs to be 0.}

\item{parameterNameObject}{The name of the parameter for passing the model to the prediction function}

\item{parameterNameData}{The name of the parameter for passing the data to the prediction function}

\item{dataFrameFlag}{Logical value indicating whether the data object is a data frame rather than a matrix.}

\item{...}{Optional, additional parameters that will be passed to the prediction function.}
}
\value{
A numeric (integer) vector of predicted group memberships.
}
\description{
This function predicts group membership and returns a numeric vector with results.
}
\examples{
 #First, define group membership and create the example feature data
 group<-factor(c(rep("Group1",4),rep("Group2",5)))
 names(group)<-paste("Sample",1:9,sep="")
 dataset<-data.frame(
   Feature1=c(5.1,5.0,6.0,2.9,4.8,4.6,4.9,3.8,5.1),
   Feature2=c(2.6,4.0,3.2,1.2,3.1,2.1,4.5,6.1,1.3),
   Feature3=c(3.1,6.1,5.8,5.1,3.8,6.1,3.4,4.0,4.4),
   Feature4=c(5.3,5.2,3.1,2.7,3.2,2.8,5.9,5.8,3.1),
   Feature5=c(3.2,4.4,4.8,4.9,6.0,3.6,6.1,3.9,3.5)
   )
 rownames(dataset)<-names(group)
 #train a model - here we use a logit model instead of ANN as a demonstration
 mod<-glm(group~Feature1+Feature2+Feature3+Feature4+Feature5,
   data=data.frame(group=group,dataset),family="binomial")
 predictWrapper(model=mod,dataSet=dataset,firstLevel=0,type="response")
}
