% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mr_egger_rjags.R
\name{mr_egger_rjags}
\alias{mr_egger_rjags}
\title{Bayesian implementation of the MR-Egger model with choice of prior distributions fitted using JAGS.}
\usage{
mr_egger_rjags(object, prior = "default", betaprior = "",
  sigmaprior = "", n.chains = 1, n.burn = 1000, n.iter = 5000,
  seed = NULL, rho = 0.5, ...)
}
\arguments{
\item{object}{A data object of class \code{mr_format}}

\item{prior}{A character string for selecting the prior distributions; "default" selects a non-informative set of priors; "weak" selects weakly informative priors; "pseudo" selects a pseudo-horseshoe prior on the causal effect, "joint" selects a joint prior on the intercept and slope}

\item{betaprior}{A character string in JAGS syntax to allow a user defined prior for the causal effect.}

\item{sigmaprior}{A character string in JAGS syntax to allow a user defined prior for the residual standard deviation}

\item{n.chains}{Numeric indicating the number of chains used in the MCMC estimation, the default is 1 chain.}

\item{n.burn}{Numeric indicating the burn-in period of the Bayesian MCMC estimation. The default is 1000 samples.}

\item{n.iter}{Numeric indicating the number of iterations in the Bayesian MCMC estimation. The default is 5000 iterations.}

\item{seed}{Numeric indicating the random number seed. The default is the rjags default.}

\item{rho}{Numeric indicating the correlation coefficient input into the joint prior distribution. The default value is 0.5}

\item{...}{Additional arguments passed through to \code{rjags::jags.model()}}
}
\value{
The result object of class eggerjags contains the following components:
\describe{
\item{AvgPleio}{The mean of the simulated pleiotropic effect}
\item{CausalEffect}{The mean of the simulated causal effect}
\item{StandardError}{Standard deviation of the simulated causal effect}
\item{sigma}{The value of the residual standard deviation}
\item{CredibleInterval}{The credible interval for the causal effect, which includes the lower (2.5\%), median (50\%) and upper intervals (97.5\%)}
\item{samples}{Output of the Bayesian MCMC samples}
\item{Priors}{The specified priors}
}
}
\description{
Bayesian implementation of the MR-Egger model with choice of prior distributions fitted using JAGS.
}
\examples{
data(bmi_insulin)
fit <- mr_egger_rjags(bmi_insulin, n.chains = 1)
summary(fit)
plot(fit$samples)
# 90\% credible interval
fitdf <- do.call(rbind.data.frame, fit$samples)
cri90 <- quantile(fitdf$Estimate, probs = c(0.05,0.95))
print(cri90)

}
\references{
Bowden et. al., Mendelian randomization with invalid instruments: effect estimation and bias detection through Egger regression. International Journal of Epidemiology 2015. 44(2): p. 512-525. \url{https://doi.org/10.1093/ije/dyv080}
}
