\name{FASTmrMLM}
\alias{FASTmrMLM}
\title{To perform GWAS with FASTmrMLM method}
\description{
FAST multi-locus random-SNP-effect Mixed Linear Model}
\usage{
FASTmrMLM(gen,phe,outATCG,genRaw,kk,psmatrix,svpal,svrad,svmlod,Genformat,CLO)
}
\arguments{
	\item{gen}{genotype matrix.}
	\item{phe}{phenotype matrix.}
	\item{outATCG}{genotype for code 1.}
	\item{genRaw}{raw genotype.}
	\item{kk}{kinship matrix.}
	\item{psmatrix}{population structure matrix.}
	\item{svpal}{Critical P-value for selecting variable.}
      \item{svrad}{Search Radius in search of potentially associated QTN.}
      \item{svmlod}{Critical LOD score for significant QTN.}
	\item{Genformat}{Format for genotypic codes.}
      \item{CLO}{number of CPU.}
	}
\author{
Zhang Ya-Wen, Li Pei, Zhang Yuan-Ming\cr
Maintainer: Yuan-Ming Zhang<soyzhang@mail.hzau.edu.cn>
}
\examples{
G1=data(Gen)
P1=data(Phe)
Readraw=ReadData(fileGen=Gen,filePhe=Phe,fileKin=NULL,filePS =NULL,
Genformat=1)
InputData=inputData(readraw=Readraw,Genformat=1,method="FASTmrMLM",trait=1)
result=FASTmrMLM(InputData$doMR$gen,InputData$doMR$phe,
InputData$doMR$outATCG,InputData$doMR$genRaw,
InputData$doMR$kk,InputData$doMR$psmatrix,0.01,svrad=20,
svmlod=3,Genformat=1,CLO=1)   
}


