\name{tuples}
\alias{tuples}
\title{Determine all n-tuples using the elements of a set.}
\usage{
  tuples(set, n = length(set), repeats = FALSE)
}
\arguments{
  \item{set}{a set}

  \item{n}{length of each tuple}

  \item{repeats}{if set contains duplicates, should the
  result?}
}
\value{
  a matrix whose rows are the n-tuples
}
\description{
  Determine all n-tuples using the elements of a set.
}
\examples{
tuples(1:2, 5)
apply(tuples(c('x','y','z'), 3), 1, paste, collapse = '')

# multinomial coefficients
r <- 2 # number of variables, e.g. x, y
n <- 2 # power, e.g. (x+y)^2
apply(burst(n,r), 1, function(v) factorial(n)/ prod(factorial(v))) # x, y, xy
mp('x + y')^n

r <- 2 # number of variables, e.g. x, y
n <- 3 # power, e.g. (x+y)^3
apply(burst(n,r), 1, function(v) factorial(n)/ prod(factorial(v))) # x, y, xy
mp('x + y')^n

r <- 3 # number of variables, e.g. x, y, z
n <- 2 # power, e.g. (x+y+z)^2
apply(burst(n,r), 1, function(v) factorial(n)/ prod(factorial(v))) # x, y, z, xy, xz, yz
mp('x + y + z')^n
}

